function [P_RT,Pbar,A_nRT,lnf,dP_RTdr] = PS94(r,T,phs_id)
if phs_id ==1
    C = [
        0               0              0.24657688e+6  0.51359951e+2  0              0;             %1
        0               0              0.58638965e+0 -0.28646939e-2  0.31375577e-4  0;             %2
        0               0             -0.62783840e+1  0.14791599e-1  0.35779579e-3  0.15432925e-7; %3
        0               0              0             -0.42719878e+0 -0.16325155e-4  0;             %4
        0               0              0.56654978e+4 -0.16580167e+2  0.76560762e-1  0;             %5
        0               0              0              0.10917883e+0  0              0;             %6
        0.38878656e+13 -0.13494878e+9  0.30916564e+6  0.75591105e+1  0              0;             %7
        0               0             -0.65537898e+5  0.18810675e+3  0              0;             %8
        -0.14182435e+14  0.18165390e+9 -0.19769068e+6 -0.23530318e+2  0              0;             %9
        0               0              0.92093375e+5  0.12246777e+3  0              0];            %10
elseif phs_id == 2
    C = [
        0               0              0.18261340e+7   0.79224365e+2  0              0            ; %1
        0               0              0               0.66560660e-4  0.57152798e-5  0.30222363e-9; %2
        0               0              0               0.59957845e-2  0.71669631e-4 0.62416103e-8; %3
        0               0              -0.13270279e+1 -0.15210731e+0  0.53654244e-3  -0.71115142e-7; %4
        0               0              0.12456776e+0   0.49045367e+1  0.98220560e-2  0.55962121e-5;  %5
        0               0              0               0.75522299e+0  0              0;             %6
        -0.39344644e+12 0.90918237e+8  0.42776716e+6  -0.22347856e+2  0              0;             %7
        0               0              0.40282608e+3   0.11971627e+3  0              0;             %8
        0               0.22995650e+8 -0.78971817e+5  -0.63376456e+2  0              0;             %9
        0               0              0.95029765e+5   0.18038071e+2  0              0];            %10
end
% calculation of coefficients Pitzer & Sterner (1994)
c1  = C(1,1)*T.^(-4)  + C(1,2)*T.^(-2)  + C(1,3)*T.^(-1)  + C(1,4)  + C(1,5)*T  + C(1,6)*T.^2;
c2  = C(2,1)*T.^(-4)  + C(2,2)*T.^(-2)  + C(2,3)*T.^(-1)  + C(2,4)  + C(2,5)*T  + C(2,6)*T.^2;
c3  = C(3,1)*T.^(-4)  + C(3,2)*T.^(-2)  + C(3,3)*T.^(-1)  + C(3,4)  + C(3,5)*T  + C(3,6)*T.^2;
c4  = C(4,1)*T.^(-4)  + C(4,2)*T.^(-2)  + C(4,3)*T.^(-1)  + C(4,4)  + C(4,5)*T  + C(4,6)*T.^2;
c5  = C(5,1)*T.^(-4)  + C(5,2)*T.^(-2)  + C(5,3)*T.^(-1)  + C(5,4)  + C(5,5)*T  + C(5,6)*T.^2;
c6  = C(6,1)*T.^(-4)  + C(6,2)*T.^(-2)  + C(6,3)*T.^(-1)  + C(6,4)  + C(6,5)*T  + C(6,6)*T.^2;
c7  = C(7,1)*T.^(-4)  + C(7,2)*T.^(-2)  + C(7,3)*T.^(-1)  + C(7,4)  + C(7,5)*T  + C(7,6)*T.^2;
c8  = C(8,1)*T.^(-4)  + C(8,2)*T.^(-2)  + C(8,3)*T.^(-1)  + C(8,4)  + C(8,5)*T  + C(8,6)*T.^2;
c9  = C(9,1)*T.^(-4)  + C(9,2)*T.^(-2)  + C(9,3)*T.^(-1)  + C(9,4)  + C(9,5)*T  + C(9,6)*T.^2;
c10 = C(10,1)*T.^(-4) + C(10,2)*T.^(-2) + C(10,3)*T.^(-1) + C(10,4) + C(10,5)*T + C(10,6)*T.^2;
% ------------------------------------------------------------------------
P_RT =  r + c1.*r.^2 - r.^2.*((c3 + 2*c4.*r + 3*c5.*r.^2 + 4*c6.*r.^3)./...
    (c2 + c3.*r + c4.*r.^2 + c5.*r.^3 + c6.*r.^4).^2) ...
    + c7.*r.^2.*exp(-c8.*r) + c9.*r.^2.*exp(-c10.*r);
Pbar = P_RT.*8.314462.*T*1e6/1e5;

dP_RTdr = 1 + 2.*c1.*r - 2.*r.*(4.*c6.*r.^3 + 3.*c5.*r.^2 + 2.*c4.*r + c3)./(c6.*r.^4 + c5.*r.^3 + c4.*r.^2 + c3.*r + c2).^2 ...
    - r.^2.*(12.*c6.*r.^2 + 6.*c5.*r + 2.*c4)./(c6.*r.^4 + c5.*r.^3 + c4.*r.^2 + c3.*r + c2).^2 ...
    + 2.*r.^2.*(4.*c6.*r.^3 + 3.*c5.*r.^2 + 2.*c4.*r + c3).^2./(c6.*r.^4 + c5.*r.^3 + c4.*r.^2 + c3.*r + c2).^3 ...
    + 2.*c7.*r.*exp(-c8.*r) - c7.*r.^2.*c8.*exp(-c8.*r) + 2.*c9.*r.*exp(-c10.*r) - c9.*r.^2.*c10.*exp(-c10.*r);
A_nRT = 0*log(r) + c1.*r + ...
    (1./(c2 + c3.*r +c4.*r.^2 + c5.*r.^3 + c6.*r.^4) ...
    - 1./c2 ) - (c7./c8).*(exp(-c8.*r)-1) - (c9./c10) ...
    .* (exp(-c10.*r)-1);

lnf = log(r) + A_nRT + Pbar./(r.*83.14462.*T) + log(83.14462*T) -1;
end