clear,clf
ele_name             = {'Si','O'};
[names,nphs,molm,td] = thermo_data(ele_name);
molw                 = nphs*molm;
V_Jbar               = td(:,3);
rho                  = molw./V_Jbar*1e5

%% Functions
function [phases,nphs,molm,td,data_name] = thermo_data(Cname,phases)
np = 289;ndat = 25;nc = 19;
fid = fopen('tc-ds633.bin','r');td = fread(fid,'double');fclose(fid);td = reshape(td,np,ndat);
fid = fopen('nphs-ds633.bin','r');nphs = fread(fid,'double');fclose(fid);nphs = reshape(nphs,np,nc);
fid = fopen('names-ds633.txt','r'); for ip = 1:np,names{ip,1} = fscanf(fid,'%s\n',1);end;fclose(fid);
fid = fopen('elements-ds633.txt','r'); for ip = 1:nc,elements{ip,1} = fscanf(fid,'%s\n',1);end;fclose(fid);
fid = fopen('td-colnames-ds633.txt','r'); for ip = 1:ndat,data_name{ip,1} = fscanf(fid,'%s\n',1);end;fclose(fid);
fid = fopen('elemass-ds633.bin','r');molm = fread(fid,'double');fclose(fid);
for i_c = 1:length(elements)
    c_curr = find(strcmp(Cname,elements(i_c)));
    if ~isempty(c_curr)
        c_ind(i_c) = c_curr;
    else
        c_ind(i_c) = -1;
    end
end
ele_sys = find(c_ind>0);
if sum(c_ind==-1)>0
    inc_phs_id  = find(sum(abs(nphs(:,c_ind==-1)),2)==0);
end
if exist('phases','var') && ~isempty(phases)
    for ip = 1:length(phases)
        if sum(strcmp(names(inc_phs_id),phases(ip)))==1
            p_id(ip) = inc_phs_id(strcmp(names(inc_phs_id),phases(ip)));
        else
            ele_phs = find(nphs(strcmp(names,phases(ip)),:)>0);
            ele_not_present = '';
            for i_ele = 1:length(ele_phs)
                if sum(ele_sys==ele_phs(i_ele))==0
                    ele_not_present = [ele_not_present ', ' elements{ele_phs(i_ele)}];
                end
            end
            error(['missing elements: ' ele_not_present])
        end
    end
else
    p_id   = inc_phs_id;
    phases = names(inc_phs_id);
end
nphs                   = nphs(p_id,c_ind>0);
nphs(:,c_ind(c_ind>0)) = nphs;
molm                   = molm(c_ind>0);
molm(c_ind(c_ind>0))   = molm;
td                     = td(p_id,:);
end