package parsetree;

import java.awt.*;
import MadScape.Zwischenrepraesentation.*;

public class TextList extends Element{

  public static final int SQUARE = 1;
  public static final int CIRCLE = 2;
  public static final int DISC   = 3;

  public static int DEFAULT_TYPE = TextList.CIRCLE;

  private int type;

  private Text li[];

  /**
   @exception lang.IllegalArgumentException falscher type-Wert
   */
  
  public TextList (Text items[], int type)
  throws IllegalArgumentException {
    super();
    this.li = items;

    switch (type){
    case TextList.SQUARE :
    case TextList.CIRCLE :
    case TextList.DISC   : this.type=type;break;
    default              : throw new IllegalArgumentException();
    }

  }

  void testausgabe(int tabs){
    Text.tabs(tabs);
    System.out.print("<UL TYPE=");
    switch (type){
    case TextList.SQUARE : System.out.print("SQUARE");break;
    case TextList.CIRCLE : System.out.print("CIRCLE");break;
    case TextList.DISC   : System.out.print("DISC");break;
    }
    System.out.println(" >");

    for (int i=0 ; i<li.length ; i++){
      Text.tabs(tabs+1);
      System.out.println("<LI>");
      li[i].testausgabe(tabs+2);
      Text.tabs(tabs+1);
      System.out.println("</LI>");
    }

    Text.tabs(tabs);
    System.out.println("</UL>");
  }

  /* implementierte Methoden von Gruppe d */
  /* begin */

    
    public int getListType() {
	return type;
    }

    /** Liefert die Lnge des in der Liste enthaltenen Arrays von Texten */
    public int getTextArrayLength() {
	return li.length;
    }

    /** Liefert den x. Eintrag im Text-Array
	@param x Indexvariable fr Array-Zugriff
    */
    public Text getTextAt(int x ) {   
      if ( (x < 0) || (x > this.getTextArrayLength()) ) {
	  System.out.println("Zugriff auf Element, das nicht im Array ist!");
      }
      return li[x];
    }

    /**
      Liefert die Attribute fr die Liste.
      @param attr Instanz des Attribute-Objektes
      @return Attribute ,ein neues veraendertes Attribute-Objekt.
    */
    public Attribute changeAttribute(Attribute attr) {
	Attribute newattr = (Attribute)attr.clone();
	newattr.setzeersterlisteneintrag(true);
	newattr.setzelistentyp(type);
	return newattr;
    }
    
    /** Der Typ des Elements ist TextList. */
    private static final int typ = TEXTLIST;

    /** Gibt den Typ des Elements zurueck. */
    public int gettype() {
	return typ;
    }

  /* end */
}
