package parsetree;

import java.awt.*;
import MadScape.Zwischenrepraesentation.*;

public class TextImage extends Element{

  public static final int LEFT   = 1;
  public static final int RIGHT  = 2;
  public static final int TOP    = 3;
  public static final int MIDDLE = 4;
  public static final int BOTTOM = 5;

  public static String DEFAULT_SRC = "";
  public static int DEFAULT_ALIGN = TextImage.BOTTOM;
  public static ImageSize DEFAULT_WIDTH = new Percent(100);
  public static ImageSize DEFAULT_HEIGHT = new Percent(100);

  private String src;
  private int align;
  private ImageSize width;
  private ImageSize height;

  /**
   @exception lang.IllegalArgumentException falscher Align-Wert
   */

  public TextImage(String src, int align, ImageSize width, ImageSize height)
  throws IllegalArgumentException{
    super();
    this.src=src;

    switch (align){
    case TextImage.LEFT   :
    case TextImage.RIGHT  :
    case TextImage.TOP    :
    case TextImage.MIDDLE :
    case TextImage.BOTTOM : this.align=align; break;
    default               : throw new IllegalArgumentException();
    }

    this.width=width;
    this.height=height; 
  }

  void testausgabe(int tabs){
    Text.tabs(tabs);
    System.out.print("<IMG SRC=\042" + this.src + "\042 ALIGN=");
    switch (align){
    case TextImage.LEFT   : System.out.print("LEFT");break;
    case TextImage.RIGHT  : System.out.print("RIGHT");break;
    case TextImage.TOP    : System.out.print("TOP");break;
    case TextImage.MIDDLE : System.out.print("MIDDLE");break;
    case TextImage.BOTTOM : System.out.print("BOTTOM");break;
    }
    System.out.print(" WIDTH="); 
    this.width.testausgabe();
    System.out.print(" HEIGHT=");
    this.height.testausgabe();
    System.out.println(" >"); 
  }

  /* implementierte Methoden von Gruppe d */
  /* begin */

    /** 
      Liefert die Ausrichtung des Bildes zurck.
    */
    public int getalign() {
	return align;
    }

    /** Liefert die URL des Bildes zurck. */
    public String getsrc() {
	return src;
    }

    /** Liefert die geforderte Breite des Bildes zurck. */
    public ImageSize getwidth() {
	return width;
    }

    /** Liefert die geforderte Hhe des Bildes zurck. */
    public ImageSize getheigth() {
	return height;
    }
    
    /** Element ist vom Typ TextImage. */
    private static final int typ = TEXTIMAGE;

    /** Der Typ des Elements wird zurueckgeliefert. */
    public int gettype() {
	return typ;
    }

  /* end */


}
