package parsetree;

import java.awt.*;
import MadScape.Zwischenrepraesentation.*;

public class TextFont2 extends Markup{

  /** Konstante fr den Farb-Default-Wert ist "schwarz" */
  public static final Color DEFAULT_COLOR = Color.black;
  /** Konstante fr den Gren-Default-Wert ist "3" */
  public static final int DEFAULT_SIZE = 2;
  /** Konstante fr die minimale Gre ist "1" */
  public static final int MIN_SIZE = 1;
  /** Konstante fr die maximale Gre ist "7" */
  public static final int MAX_SIZE = 7;

  private Color color;
  private int size;

  public TextFont2(Text text, Color color, int size)
  throws IllegalArgumentException {
    super(text);
    this.color=color;

    if (size>=TextFont.MIN_SIZE & size<=TextFont.MAX_SIZE){
      this.size=size;
    }
    else {
      throw new IllegalArgumentException();
    }
 
  }

  void testausgabe(int tabs){
    Text.tabs(tabs);   
    System.out.print(
      "<FONT SIZE=" + this.size + " COLOR=" + 
      this.color.getRed() + "|" +
      this.color.getGreen() + "|" +
      this.color.getBlue() + " >" + "\n"
    );

    this.text.testausgabe(tabs+1);

    Text.tabs(tabs);
    System.out.println("</FONT>");
  }

  /* implementierte Methoden von Gruppe d */
  /* begin */

    /** Setzt das Farb- und das Gren-Attribut
	@param attr die zuletzt gltigen Attribute  */
    public Attribute changeAttribute(Attribute attr) {
	Schrift schrift = new Schrift(attr.gibschrift().getName(),
				      attr.gibschrift().getStyle(),
				      (size*4)+4);
	Attribute newattr = new Attribute(attr, color, schrift);

	//	Attribute newattr = new Attribute(attr, color);

	return newattr;
    }

    /** Element ist vom Typ TextFont. */
    private static final int typ = TEXTFONT;

    /** Der Typ des Elements wird zurueckgegeben. */
    public int gettype() {
	return typ;
    }
    
  /* end */

}
