package parsetree;

import java.awt.*;

/**
  Ein Text-Objekt ist ein Text-Knoten eines Parsetrees.<br>
  <br>
  Dementsprechend enthlt ein Text-Objekt mehrere Element-Objekte.
  Text-Objekte bilden den Inhalt von Page-, Markup- und List-Knoten.
  <br>
  @see parsetree.Page
  @see parsetree.TextList
 */

public class Text{

  /* Konstante, die ausschlielich von der Methode Text.tabs() benutzt wird */
  static final String TABS = "    ";

  /* 
   Klassenmethode, zur Einrckung des Textes in den
   testausgabe()-Methoden der Parsetree-Knoten
  */
  static final void tabs(int tabs){
    for (int i=0 ; i<tabs ; i++) System.out.print(Text.TABS);
  }

  /*
   Das Feld elements[] ist die Implementierung der 1-* Assoziation
   von Text nach Element im UML-Klassendiagramm !
   */

  private Element elements[]; 

  /**
    Der Konstruktor ist die einzige Mglichkeit, die Elemente zu setzen.
    Er wird vom Parser benutzt, um den Parsetree aufzubauen.
    @param elements[] Inhalt des Text-Knotens
    @see parsetree.Page
  */ 
  public Text(Element elements[]){
    this.elements = elements;
  }

  /*
   Die testaugabe()-Methode ist nicht public. Sie wird im parsetree-Package
   benutzt, um Page.testausgabe() zu realisieren. Sie gibt den HTML-Text aus,
   der durch das Text-Objekt reprsentiert wird, indem sie die testausgabe()-
   Methoden der beinhalteten Elemente aufruft.   
   */

  
  void testausgabe(int tabs){
    for (int i=0 ; i<elements.length ; i++){
      elements[i].testausgabe(tabs);
    }
  }

  /* implementierte Methoden von Gruppe d */
  /* begin */

    /** Liefert die Anzahl der Elemente, die Text enthlt */
    public int getLength() {
	return elements.length;
    }
    
    /** Liefert das x. Element zurck */
    public Element getElementAt(int x) {
	if ( (x < 0) || (x > this.getLength()) ) {
	    System.out.println("Zugriff auf Element, das nicht im Array ist!");
	}
	return elements[x];
    }

  /* end */
}

