package parsetree;

import java.awt.*;

public class Paragraph extends Element{

  public static final int LEFT   = 1;
  public static final int CENTER = 2;
  public static final int RIGHT  = 3;

  public static int DEFAULT_ALIGN = Paragraph.LEFT;

  private int align;

  /**
   @exception lang.IllegalArgumentException falscher align-Wert
   */

  public Paragraph(int align) throws IllegalArgumentException{
    super();
    
    switch (align){
    case Paragraph.LEFT   :
    case Paragraph.CENTER :
    case Paragraph.RIGHT  : this.align=align;break;
    default               : throw new IllegalArgumentException();
    }
 
  }

  void testausgabe(int tabs){
    Text.tabs(tabs);
    System.out.print("<P ALIGN="); 
    switch (align){
    case Paragraph.LEFT   : System.out.print("LEFT");break;
    case Paragraph.CENTER : System.out.print("CENTER");break;
    case Paragraph.RIGHT  : System.out.print("RIGHT");break;
    }
    System.out.println(" >");
  }

  /* implementierte Methoden von Gruppe d */
  /* begin */

    /** Liefert die Ausrichtung des Paragraphen zurck */
    public int getalign() {
        int a = 0;
	switch (align) {
	case LEFT   : return 1;
	case RIGHT  : return 2;
	case CENTER : return 4;
	}
	return align;
    }

    /** Element ist vom Typ Paragraph. */
    private static final int typ = PARAGRAPH;

    /** Gibt den Typ zurueck, den das Element hat. */
    public int gettype() {
	return typ;
    }
    
  /* end */
}
