package parsetree;

import java.awt.*;

/**
  Ein Objekt der Klasse Page reprsentiert einen Parsetree,
  wie er im SWP vorgestellt wurde. Ein solcher Parsetree
  ist eine Instanz-Struktur ber folgendem  
  <a href="../material/diagram00.jpeg">
    UML-Klassendiagramm
  </a>.<br>
  <br>
  Ein Parsetree ist das Ergebnis der bersetzung eines HTML-Textes.<br>
  <br>
  Dementsprechend enthlt ein Page-Objekt ein Text-Objekt.
  Weitere Attribute sind die globalen Wep-Page-Eigenschaften
  Titel, Hintergrundfarbe, Hintergrundbild und Wasserzeicheneffekt.
  Alle Attribute der Klasse knnen aussschlielich ber den Konstruktor
  gesetzt werden.<br>
  <br>
  Die Methode Testausgabe gibt den gesamten HTML-Text gem seiner
  Parsetree-Struktur aus. Das heit : Die Knotennamen werden mitausgegeben,
  und bei Markups und Listeneintrgen wird die Ausgabe in geeigneter Weise
  eingerckt.
  @see parser.Parser
  @see parser.Parser#page  
  @see parsetree.Text
 */

public class Page{

  /** Konstante fr den Titel-Default-Wert ist "NOTITLE" */
  public static final String DEFAULT_TITLE = "NOTITLE";
  /** Konstante fr den Hintergrundfarben-Default-Wert ist "wei" */  
  public static final Color DEFAULT_BGCOLOR = Color.white;
  /** Konstante fr den Hintergrundbild-Default-Wert ist "leer" */
  public static final String DEFAULT_BACKGROUND = "";
  /** Konstante fr den Wasserzeicheneffekt-Default-Wert ist "ohne"*/ 
  public static final boolean DEFAULT_BGPROPERTIES = false;

  /*
   Die Attribute der Klasse sind alle private.
   Sie knnen aussschlielich ber den Konstruktor gesetzt werden.
   Prinzip : Data Hiding !
   Der Konstruktor soll nur vom Parser benutzt werden.
   */
  
  private String title;
  private Color bgcolor;
  private String background;
  private boolean bgproperties;
 
  private Text text; 

  /**
    Der Konstruktor ist die einzige Mglichkeit, die Objekt-Attribute zu setzen.
    Er wird vom Parser benutzt, um den Parsetree aufzubauen.
    @param text Inhalt der Web-Page
    @param title Titel der Web-Page
    @param bgcolor Hintergrundfarbe der Web-Page
    @param background Die URL-Adresse des Hintergrundbilds als String
    @param bgproperties Wasserzeicheneffekt des Hintergrunds (true=mit/false=ohne)  
    @see parsetree.Text
    */ 

  public Page(Text text, String title, Color bgcolor, String background, boolean bgproperties){
    this.title = title;
    this.bgcolor = bgcolor;
    this.background = background;
    this.bgproperties = bgproperties;

    this.text = text;
  }

  /** 
    Ausgabe des HTML-Textes, der durch das Page-Objekt reprsentiert wird, 
    entlang der Parsetree-Struktur
    */


  public void testausgabe(){
      System.out.print(
       "TESTAUSGABE PARSETREE" + "\n" + "\n" +
       "Titel : " + title + "\n" +
       "Hintergrungfarbe : " +
       this.bgcolor.getRed() + "|" +
       this.bgcolor.getGreen() + "|" +
       this.bgcolor.getBlue() + "\n" +
       "Hintergrundbild  : " + background + "\n"
      );
      if (bgproperties){
        System.out.print("mit ");
      }
      else {
        System.out.print("ohne ");
      }
      System.out.print("Wasserzeicheneffekt" + "\n" + "\n");

      this.text.testausgabe(0); 
      System.out.println();
  }


  /* implementierte Methoden von Gruppe d */
  /* begin */

    /** Liefert das Hintergrundbild der Page zurck */
    public String getbackground(){
	return background;
    }

    /** Liefert die Hintergrundfarbe der Page zurck : */
    public Color getbgcolor() {
	return bgcolor;
    }

    /** Liefert die bgproperties der Page zurck */
    public boolean getbgproperties() {
	return bgproperties;
    }

    /** Liefert das Textobjekt der Page zurck */
    public Text gettext() {
	return text;
    }
 
    /** Liefert den Titel der Page zurck */
    public String gettitle() {
  	return title;
    }

  /* end */
}

