package parsetree;

import MadScape.Zwischenrepraesentation.*;
import java.awt.*;
  
public class Heading extends Markup{

  public static final int LEFT   = 1;
    public static final int CENTER = 2;
    public static final int RIGHT  = 3;
  public static final int DEFAULT_ALIGN = Heading.LEFT;

  public static final int MIN_SIZE = 1;
  public static final int MAX_SIZE = 6;
  public static final int DEFAULT_SIZE  = 3;

  private int align;
  private int size;

  private Text text;

  /**
   @exception lang.IllegalArgumentException falscher size-Wert / falscher align-Wert
   */

  public Heading(int size,Text text,int align){
    super(text);

    this.text=text;

    this.size=size;
    this.align=align;

    if (size>=Heading.MIN_SIZE & size<=Heading.MAX_SIZE){
      this.size=size;
    }
    else {
      throw new IllegalArgumentException();
    }

    switch (align){
    case Heading.LEFT   :
    case Heading.CENTER :
    case Heading.RIGHT  : this.align=align;break;
    default             : throw new IllegalArgumentException();
    }

  }

  void testausgabe(int tabs){
    Text.tabs(tabs);
    System.out.print("<H" + this.size + " ALIGN="); 
    switch (align){
    case Heading.LEFT   : System.out.print("LEFT");break;
    case Heading.CENTER : System.out.print("CENTER");break;
    case Heading.RIGHT  : System.out.print("RIGHT");break;
    }
    System.out.println(" >");

    this.text.testausgabe(tabs+1);

    Text.tabs(tabs);
    System.out.println("</H" + this.size + ">");
  }

  /* implementierte Methoden von Gruppe d */
  /* begin */

    /** Liefert die Ausrichtung der berschrift zurck <br>
        1 = links  <br>
        2 = mittig <br>
        3 = rechts 
	@return int, Ausrichtung des Ueberschrift */
    public int getalign() { 	
	int a = 0;
	switch (align) {
	case LEFT   : return 1;
	case RIGHT  : return 2;
	case CENTER : return 4;
	}
        return align;
    }

    /** Setzt das Groessen-Attribut 
	@param attr die zuletzt gltigen Attribute */
    /* erzeugt neues Attribute mit neuem Schrift-Objekt */
    public Attribute changeAttribute(Attribute attr) {
	Schrift schrift = new Schrift(attr.gibschrift().getName(),
				      Font.BOLD,
				      (7-size)*6);
	Attribute newattr = new Attribute(attr, schrift);

	return newattr;
    }
    
    /** Element ist vom Typ Heading. */
    private static final int typ = HEADING;

    /** Gibt den Typ des Elements zurueck */
    public int gettype() {
	return typ;
    }
    
  /* end */

}
