package parsetree;

import MadScape.Zwischenrepraesentation.*;
/**
 Abstrakte Super-Klasse aller Parsetree-Knoten
*/

public abstract class Element{


    /* Methoden und Konstanten der Gruppe d 
    begin */

    /** Integer-Konstante, die angibt, dass das Element vom Typ
     *  Markup ist */ 
    public static final int MARKUP     =  1;
    
    /** Integer-Konstante, die angibt, dass das Element vom Typ
     *  Word ist */ 
    public static final int WORD       =  2;

    /** Integer-Konstante, die angibt, dass das Element vom Typ
     *  Whitespace ist */ 
    public static final int WHITESPACE =  3;

    /** Integer-Konstante, die angibt, dass das Element vom Typ
     *  Linebreak ist */ 
    public static final int LINEBREAK  =  4;

    /** Integer-Konstante, die angibt, dass das Element vom Typ
     *  Line ist */ 
    public static final int LINE       =  5;

    /** Integer-Konstante, die angibt, dass das Element vom Typ
     *  Paragraph ist */ 
    public static final int PARAGRAPH  =  6;

    /** Integer-Konstante, die angibt, dass das Element vom Typ
     *  TextImage ist */ 
    public static final int TEXTIMAGE  =  7;

    /** Integer-Konstante, die angibt, dass das Element vom Typ
     *  TextList ist */ 
    public static final int TEXTLIST   =  8;

    /** Integer-Konstante, die angibt, dass das Element vom Typ
     *  Bold ist */ 
    public static final int BOLD       = 11;

    /** Integer-Konstante, die angibt, dass das Element vom Typ
     *  Italic ist */ 
    public static final int ITALIC     = 12;

    /** Integer-Konstante, die angibt, dass das Element vom Typ
     *  Underline ist */ 
    public static final int UNDERLINE  = 13;

    /** Integer-Konstante, die angibt, dass das Element vom Typ
     *  TextFont ist */ 
    public static final int TEXTFONT   = 14;

    /** Integer-Konstante, die angibt, dass das Element vom Typ
     *  Heading ist */ 
    public static final int HEADING    = 15;

    /** Integer-Konstante, die angibt, dass das Element vom Typ
     *  Nobr ist */ 
    public static final int NOBR       = 16;

    /** Integer-Konstante, die angibt, dass das Element vom Typ
     *  Anchor ist */ 
    public static final int ANCHOR     = 17;

    /** Die Typkonstante wird erst in den einzelnen Subklassen 
        gesetzt und erhaelt zunaest den allgemeinen Wert 0. */
    private static final int typ = 0;

    
    /** Liefert den Typ des Elementes zurueck */
    public int gettype() {
	return typ;
    }
    
    // end    
    
    /* Setzt das Attribute-Objekt der Elemente 
       @param Attribute das zusetzende Attribtue-Objekt */
    public Attribute changeAttribut(Attribute a) {
	return a;
    }

    abstract void testausgabe(int tabs);
}




