package MadScape.Zwischenrepraesentation;

import java.io.*;

/**
  Abstrakte Oberklasse der Elemente, die in einer Seite enthalten sein knnen.
  @author David Diestel
  @author Alexander Tobis
  @see ZRSeite
*/
public class ZwischenElement {
    
    /** LINKS, gibt die Ausrichtung fr Text, Bilder (Umlaufbild) an */
    public static final int LINKS         = 1;

    /** MITTEL, gibt die Ausrichtung fr Text, Bilder an */
    public static final int MITTEL        = 4;

    /** RECHTS, gibt die Ausrichtung fr Text, Bilder (Umlaufbild) an */
    public static final int RECHTS        = 2;

    /** OBEN, gibt Ausrichtung fr Bilder */
    public static final int OBEN          = 3;

    /** UNTEN, gibt die Ausrichtung fr Bilder an */
    public static final int UNTEN         = 5;

    /** ZWISCHENELEMENT, Element ist vom Typ Zwischenelement */
    public static final int ZWISCHENELEMENT = 0;

    /** WORT, Element ist vom Typ Wort */
    public static final int WORT            = 1;

    /** BILD, Element ist vom Typ Bild */
    public static final int BILD            = 2;

    /** LEERZEICHEN, Element ist vom Typ Leerzeichen */
    public static final int LEERZEICHEN     = 3;

    /** HLINIE, Element ist vom Typ HLinie */
    public static final int HLINIE          = 4;

    /** UMBRUCH, Elment ist vom Typ Umbruch */
    public static final int UMBRUCH         = 5;

    /** Ausrichtung der ZwischenElemente */
    public int ausrichtung;

    /** Typ des Zwischenelementes */	
    public int typ;

    /** Liefert die Ausrichtung des Elementes <br>
	LINKS         = links   <br>
	MITTEL        = mittel  <br>
	RECHTS        = rechts  <br>
	OBEN          = oben    <br>
	UNTEN         = unten
	@return Ausrichtung des Elementes
    */
    public int gibausrichtung() {
	return ausrichtung;
    }

    /** setzt die Ausrichtung des Elementes 
	@param ausrichtung ,die Ausrichtung des Elementes */
    public void setzeausrichtung(int ausrichtung) {
        this.ausrichtung = ausrichtung;
    }

    /** Gibt den Typ des Elementes zurck
	@return Typ des Elementes */
    public int gibTyp() {
	return typ;
    }


    public void ausgabe(String s){
	System.out.println(s);
    }
    	
    
    public void testausgabe() {
    }
    
}

