   
package MadScape.Zwischenrepraesentation;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.io.*;
import java.lang.*;
import java.net.*;
import java.util.*;
import parsetree.*;
import MadScape.*;
import MadScape.Zwischenrepraesentation.*;
import MadScape.GUI.*;

/** Hauptklasse 
  @author Philip Metzner
  @author Mario Meier
  @author David Diestel
  @author Alexander Tobis */
public class ZRSeite {

    WasserzeichenFilter wasserzeichenfilter = null;

    /** die voreingestellte Farbe der Links */
    public Color linkfarbe;

    /** globale Variable, die die Ausrichtung der Elemente angibt */
    private int ausrichtung = ZwischenElement.LINKS;

    private int ausrichtungvorueberschrift = ZwischenElement.LINKS;
    private boolean warueberschrift = false;
    
    private boolean warleerzeichen = false;

    /** globale Variable, die angibt, ob ein Umbruch erlaubt ist */
    private boolean keinumbruch = false;

    /** Vector zum Speichern aller ZwischenElemente als Array */
    private Vector zwischenelemente = new Vector(500, 100);
  
    /** Adresse der Seite */
    private String url = "";

    /** Die Seite, die der Parser liefert */
    private Page seite = null;

    /** Die Defaultwerte des Browser */
    private Voreinstellungen voreinstellungen = null;

    /** Der Titel der Web-Seite. */
    private String titel = "";
  
    /** Die Hintergrundfarbe der Web-Seite. */
    private Color hintergrundfarbe = null;
  
    /** Das Hintergrundbild der Web-Seite. */
    private Image hintergrund = null;
  
    /** Soll das Hintergrundbild einen Wasserzeicheneffekt haben oder nicht ? */
    private boolean hintergrundeigenschaften = false;

    /** erstes Attribute-Objekt mit den Voreinstellungen */
    private Attribute erstesAttributeobjekt = null;

    /** Liefert den Titel der Web-Seite. */
    public String gibtitel() {
	return titel;
    }

    /** Liefert die Hintergrundfarbe der Web-Seite. */
    public Color gibhintergrundfarbe() {
	return hintergrundfarbe;
    }

    /** Liefert das Hintergrundbild der Web-Seite */
    public Image gibhintergrund() {
	return hintergrund;
    }

    /** gibt die Anzahl der ZwischenElemente zurueck */
    public int gibanzahlelemente() {
        return zwischenelemente.size()-1;
    }

    public ZwischenElement gibzwischenelementbei(int x) {
	return (ZwischenElement)zwischenelemente.elementAt(x+1);
    }

    /** Wasserzeicheneffekt ja oder nein */
    public boolean gibhintergrundeigenschaften() {
	return hintergrundeigenschaften;
    }

    /** erzeugt Attribute-Objekt mit den Voreinstellungen */
    private void erzeugeerstesAttributeobjekt() {
	erstesAttributeobjekt = new Attribute (voreinstellungen.holeZeichensatz(),
					       voreinstellungen.holeSchriftfarbe());
    }

    /** generiert aus der URL die absolute URL ohne den Seitennamen 
        @param url die URL, aus der die URL ermittelt werden soll 
        @return die URL ohne den Seitennamen */
    private String ermittleabsoluteURL(String url) {
	StringBuffer rurl = new StringBuffer(url);
	for (int i=rurl.length()-1; i>0 ; i--) {
	    if (rurl.charAt(i)=='/') {
		rurl.setLength(i);
		break;
	    }
	}
	if (MadScape.TRACE) System.out.println(rurl.toString());
	return rurl.toString();
    }                                     
                                                                                
    /** Leerer Konstruktor fuer Testzwecke */
    public ZRSeite() {
    }

    /** wartet die voreingestellte Zeit lang 
	@param sek, Zeit in Sekunden, die gewartet werden soll */
    public void warte(int sek) {
	Date d = new Date();
	//	System.out.println(d.toString());
	int startzeit = d.getSeconds();
	int zwischenzeit = 0;
	int verstrichenezeit = 0;
	do { 
	    d = new Date();
	    zwischenzeit = d.getSeconds();
	    //	    System.out.println(zwischenzeit);
	    if (zwischenzeit < startzeit) {
		verstrichenezeit = startzeit - zwischenzeit;
	    }
	    else {
		verstrichenezeit = zwischenzeit - startzeit;	    
	    }
	}
	while (sek > verstrichenezeit);
    };

       
  public int gibwasserzeichenstatus() {
    //    if (wasserzeichenfilter.gibStatus() == RGBImageFilter.STATICIMAGEDONE) {
    //      System.out.println("treffer!!!!"); 
    //    }
    //    System.out.println("Wasser : " + wasserzeichenfilter.gibStatus());
    return wasserzeichenfilter.gibStatus();
  }

    //  public gibElement
    public ZRSeite (Page seite, String url, Voreinstellungen voreinstellungen) {
	this.seite = seite;
	// generiere relative URL
	
	this.url = ermittleabsoluteURL(url);
	if (MadScape.TRACE) {
	  System.out.println("ZRSeite : Absolute-URL    : " + url);
	  System.out.println("ZRSeite : Hintergrund-URL : " + seite.getbackground());
	}

	this.voreinstellungen = voreinstellungen;

	// Werte die globalen Einstellungen der Web-Page aus

	this.titel = seite.gettitle();      

	// hat die Seite ein Voreinstellung fr die Hintergrundfarbe ?
	if (seite.getbgcolor() == null) {
	    this.hintergrundfarbe = voreinstellungen.holeHintergrundfarbe();
	}
	else {
	    this.hintergrundfarbe = seite.getbgcolor();
	}

	this.hintergrundeigenschaften=seite.getbgproperties();

	// gibt es ein Hintergrundbild, true, lade Bild
	if (seite.getbackground() != "") {	    
	    String hbild = Bild.ermittleBildURL(this.url, seite.getbackground());
	    try {		
		hintergrund=Loader.ladeBild(hbild);
		if (hintergrundeigenschaften) {
		    wasserzeichenfilter = new WasserzeichenFilter();
		    FilteredImageSource fsource = new FilteredImageSource( hintergrund.getSource(), wasserzeichenfilter );
		    Toolkit tk  = Toolkit.getDefaultToolkit();
		    hintergrund = tk.createImage(fsource);
		    //	    warte(5);
		}	       		
	    }
	    catch (LoaderException e) {              
	      	hintergrund = null;
	    }
	}	

	erzeugeerstesAttributeobjekt();
        if (MadScape.TRACE) 
	  ausgabe("Testausgabe von der Zwischenreprsentation");	 
	erzeugeliste(seite.gettext(), erstesAttributeobjekt);            	
       	if (MadScape.TRACE)  test();
	//	System.out.println("OK ZRSeite beendet :-)");
    }

    /** Legt das bergebene ZwischenElement oben auf den Vector 
	@param z das Element, das auf den Vector gelegt werden soll */
    private void pop (ZwischenElement z) {
	zwischenelemente.insertElementAt(z, zwischenelemente.size());
    }

  /** Methode zur Ausgabe von Strings */
    public void ausgabe(String s){
	System.out.println(s);
    }

  /** Routine fuer Testzwecke */
    public void test(){
        int l = gibanzahlelemente();
	System.out.println("Anzahl der Elemente im Vektor : " + l);
	for (int i = 0;i < l;i++){
	    gibzwischenelementbei(i).testausgabe();
	}    
    }  

    public static void main(String[] args) {
      //      ZRSeite zr = new ZRSeite();
      //      zr.ladeersatzbilder();
      System.out.println("Nur fr Testzwecke !");
    }

  /** Erzeugt ein Zwischenelement und verknuepft es mit einem Attribut 
	@param e Element, das in ein Zwischenelement konvertiert werden soll
	@param a Attribut fuer das Zwischenelement */	    
    private ZwischenElement erzeugeZElement(Element e, Attribute a) {
	ZwischenElement zElement;
	switch (e.gettype()) {
	case Element.WORD:
	    if (MadScape.TRACE) ausgabe("Wort");
	    Word word;
	    word = (Word)e;
	    zElement = new Wort( word.getStringvalue(), a);
	    zElement.setzeausrichtung(ausrichtung);
	    break;
	case Element.WHITESPACE:
	    if (MadScape.TRACE) ausgabe("Leerzeichen");
	    zElement = new Leerzeichen(keinumbruch, a);
	    zElement.setzeausrichtung(ausrichtung);	  
	    break; 
	case Element.LINEBREAK:
            if (MadScape.TRACE)  ausgabe("Umbruch");
	    zElement = new Umbruch(a); 
	    break;
	case Element.LINE:
	    if (MadScape.TRACE) ausgabe("Horizontale Linie");
	    zElement = new HLinie(a);
	    break;
	default:
	    if (MadScape.TRACE) ausgabe("Bild");
	    TextImage ti;
	    ti = (TextImage)e;
	    zElement = new Bild(ti.getalign(), url, ti.getsrc(), a, ausrichtung, ti.getwidth(), ti.getheigth());
	    // if (ausrichtung == ZwischenElement.MITTEL)
	    //	    zElement.setzeausrichtung(ti.getalign());
	    if (MadScape.TRACE) System.out.println("ALIGN der Bilder : " + ti.getalign());
	}
	
	return zElement;
    } 

 private void erzeugeliste(Text t , Attribute a )  {   
     int l = t.getLength();
     int zaehler = 0;				   
     while (zaehler < l)  {	     
	 Element e = t.getElementAt(zaehler);
	 switch (e.gettype()) {
	 case Element.LINE:
	 case Element.WHITESPACE:
	   if (!warleerzeichen) {
	     pop(erzeugeZElement( e,a ));	   	     
	     warleerzeichen = true;
	   }
	   else {
	     warleerzeichen = false;
	   }
	   break;
	 case Element.LINEBREAK:
	 case Element.TEXTIMAGE:
	     pop(erzeugeZElement( e,a ));
	     break;
	 case Element.WORD:
	   // wenn letztes Element eine Ueberschrift war alte Ausrichtung wiederherstellen 
	   //	   if (warueberschrift) {
	   //	     ausrichtung = ausrichtungvorueberschrift;
	   //	     warueberschrift = false;
	   //}
	     warleerzeichen = false;
	     int j = zaehler;
	     String woerter = "";
	     while ((j < l) && (t.getElementAt(j).gettype() == Element.WORD))
	       /* Naechstes Element ein Wort ? Wenn ja, fuege an das Vorige an */
	       {
		 Word word;
		 word = (Word)t.getElementAt(j);				
		 woerter = woerter + word.getStringvalue();
		 if (MadScape.TRACE) ausgabe(woerter);
		 j = j + 1;					 
	     }
	     pop(erzeugeZElement( new Word(woerter) ,a ));
	     zaehler = j - 1;                               
	     break;
 
	 case Element.PARAGRAPH:
	     Paragraph paragraph;
	     paragraph = (Paragraph)e;
	     ausrichtung = paragraph.getalign();
	     pop(new Umbruch(a));
	     pop(new Umbruch(a));
	     break;
	 case Element.TEXTLIST:
	     TextList textlist;
	     textlist = (TextList)e;
	     int anzahl = textlist.getTextArrayLength();        /* Anzahl der Listenzeilen */
	     int ebene = a.giblistenzaehler();                  /* Verschachtelungsebene ermitteln */
	     int listentyp = textlist.getListType(); 
	     // if (a.giblistenzaehler() == 0)
	       pop(new Umbruch(a));                            /*   Zustzlichen Zeilenumbruch einfgen */
	     if (MadScape.TRACE) ausgabe("Listenbearbeitung");
	     for (int i = 0;i < anzahl;i++) {
		 Text text = textlist.getTextAt(i);	      
		 Attribute newattr = new Attribute(a);	        /* Kopier aktuelles Attributobjekt */	    
		 newattr.setzelistenzaehler( ebene + 1 );       /* naechste hoehere Listenebene setzen */
		 newattr.setzelisteneintrag(true);              /* Listeneintrag setzen */
		 newattr.setzeersterlisteneintrag(true);
	 	 newattr.setzelistentyp(listentyp);
		 erzeugeliste(text,newattr);                    /* Listenzeile bearbeiten */ 

 		 if (MadScape.TRACE)
		  System.out.println("i = "+i+" anzahl="+anzahl);
		 if (i+1 != anzahl) pop(new Umbruch(a));        /* Wenn nicht letzte Listenzeile, dann Umbruch einfuegen */
 	     }
	     break;
	     /* Element ist ein Markup */
	 default : {             
	     Markup markup;
	     markup = (Markup)e;	     
	     int type = markup.gettype();                       /* Type des Markups ermitteln */
	     switch (type){
	     case Element.ANCHOR:
		 /* besondere Behandlung fr Links (Farbe muss gesetzt werden + unterstrichen */	    
	         Anchor anchor;
		 anchor = (Anchor)markup;
	         erzeugeliste(markup.getText() , anchor.changeAttribute(a, voreinstellungen.holeLinkfarbe()));
		 break;
	     case Element.HEADING:
	       // alte Ausrichtung merken
	       // flag setzen, das letztes Element Uebschrift war
	       if (!warueberschrift) {		 
		 ausrichtungvorueberschrift = ausrichtung;
		 warueberschrift = true;
		 // System.out.println("ZRSeite : neue Ueberschrift : Ausrichtung vor Ueberschrift : " + ausrichtung);	    } 
	       }
		 /* besondere Behandlung fuer Ueberschriften ( Umbruch Text Umbruch ) */
       		 ausrichtung = markup.getalign();   
		 //System.out.println("ZR : " + ausrichtung);
		 //warte(2);
		 pop(new Umbruch(a));
	         erzeugeliste(markup.getText() , markup.changeAttribute(a));	     
		 pop(new Umbruch(a));
		 ausrichtung = ausrichtungvorueberschrift;
		 warueberschrift = false;
		 // System.out.println("ZRSeite : neue Ueberschrift : Ausrichtung nach Ueberschrift : " + ausrichtung);
		 break;
             default:{
	         erzeugeliste(markup.getText() , markup.changeAttribute(a));  
       	     }	 
	     }
	     
	 }
	 }
	 /* Wenn Listeneintrag, darf nur erstes Element Atrribut ersterlisteneintrag = true bekommen */
	 if (a.istersterlisteneintrag() == true){
	     if (MadScape.TRACE) 
	       System.out.println("Ersterlisteneintrag wird auf false gesetzt !");
	     Attribute newattr = new Attribute(a);
	     newattr.setzeersterlisteneintrag(false);
	     a = newattr;
	 }   
	 zaehler = zaehler + 1; 
     }
 }
}
