package MadScape.Zwischenrepraesentation;

import java.awt.*;
import java.awt.image.*;

class WasserzeichenFilter extends RGBImageFilter{

    public int status = 0;

    public WasserzeichenFilter() {
	canFilterIndexColorModel = true;
    }

    public int filterRGB(int x, int y, int rgb) {
	int rot = (rgb & 0xff0000)>>16;
	int gruen = (rgb & 0xff00)>>8;
	int blau = rgb & 0xff;
	
	int grau = (rot+gruen+blau)/20+200;
	if( grau > 255)
	    grau = 255;
	
	return ((grau<<16)+(grau<<8)+(grau)+0xff000000);
    }
    
    public void imageComplete(int s) {
	status = s;
	//       	System.out.println("ZRSeite : Image complete ! " + s);
	//       	if (s == STATICIMAGEDONE) System.out.println("treffer");
    }

    /** gibt den Status des Filters zurck <br>
	STATICIMAGEDOWN = fertig */
    public int gibStatus() {
	return status;
    }
       
}



