package MadScape.Zwischenrepraesentation;

import java.util.*;
import java.awt.*;
import java.lang.*;
import parsetree.*;
import MadScape.*;
import java.net.*;
import MadScape.GUI.*;

 
/** Enthlt eine Grafik und deren Formatierung.
    @author David Diestel
    @author Alexander Tobis */
public class Bild extends ZwischenElement {
              
    /** das Ersatzbild */
    private Image ersatzbild = null;
	                
    /** die URL des Bildes als String */
    private String URLbild;

    /** Das Bild das dargestellt werden soll. */
    private Image bild = null;

    /** bildzentriert, gibt an, ob das Bild zentriert werden soll */
    private boolean bildzentriert = false;

    /** Die tatschliche Hhe des Bildes in Pixeln. */
    private int hoehe;
    
    /** Die tatschliche Breite des Bildes in Pixeln. */
    private int breite;

    /** Die Mae des Bildes beziehen sich auf einen   
        prozentualen Anteil an der Fenstergroesse oder auf eine
        tatsaechliche Soll-Groesse in Pixeln. */
    private boolean istprozent = false;

    /** Die Attribute des Bildes */
    private Attribute attribute;

    /** attribute, liefert das Attributeelement des Bild-Elementes  zurck */
    public Attribute gibattribute() {
	return attribute;
    }

    /** int, liefert die Hhe des Bildes */
    public int gibhoehe() {
	return hoehe;
    }

    /** int, liefert die Breite des Bildes */
    public int gibbreite() {
       	return breite;
    }

    /** Image, liefert das eigentliche Bild zurck */
    public Image gibbild() {
	return bild;
    }

    /** boolean, liefert die Ausrichtung des Bildes zurck */
    public boolean gibbildzentriert() {
	return bildzentriert;
    }

    /** Gibt zurueck, ob die Mae des Bildes in Pixeln 
	oder in Prozent angegeben sein sollen */ 
    public boolean gibistprozent(){
      return istprozent;
    }

    /** Ermittelt aus der URL zur Seite und der URL des Bildes die absolute
	URL des Bildes.
	@param seiteURL die URL zur Seite
	@param bildURL die URL des Bildes
	@return die absolute Adresse des Bildes
    */
    public static String ermittleBildURL(String seiteURL, String bildURL) {
	// welches Protokoll wird verwand ?
	String protokoll = bildURL.substring(0, 5);
	protokoll = protokoll.toUpperCase();

	// nur wenn HTTP oder FILE ist die URL richtig
	if ( (protokoll.compareTo("HTTP:") == 0) ||
	     (protokoll.compareTo("FILE:") == 0) ) {
	    if (MadScape.TRACE) System.out.println("ZRSeite : BildURL : " + bildURL);
	    return bildURL;	    
	}
	
	// ansonsten URL Bild an URL zur Seite anhaengen
	return (seiteURL+"/"+bildURL);	
    }

    /* Methode zum laden des Ersatzbildes */                             
    private Image ladeersatzbild() {
        // Bilder werden lokal geladen 
	Image ersatzbild = null;
	int anzahlersatzbilder=11;

	//        String pfad = new String("file://" + System.getProperty("user.dir") + 
	//				 "/MadScape/Zwischenrepraesentation/images/");
		
        String bilder[] = {"M_AlexK.jpg", 
			   "M_AlexL.jpg", 
			   "M_AndreB.jpg",
			   "M_AndreV.jpg",
			   "M_ChristophS.jpg", 
			   "M_David.jpg",
			   "M_MaxH.jpg",
			   "M_TomS.jpg",
			   "alext2.gif",
			   "alext2.gif",
			   "alext3.gif" };
	  /*
	    "data.gif", "url.gif", "ex02_or.gif",
	    "qm01_gr.gif", "qm01_or.gif", "smiley.gif",
	    "sry.gif", "critic_q.gif", "ex02_gr.gif"};
	  */
	if (MadScape.TRACE) System.out.println("ZRSeite : Lade Ersatzbild");
	int i = 0;
  	try {
	    Random random = new Random();	
	    i = java.lang.Math.abs( (random.nextInt() % anzahlersatzbilder) );	    
	    if (MadScape.TRACE) System.out.println(bilder[i]);
	    ersatzbild = Loader.ladeLokalesBild(bilder[i]);	    
	}
	catch (LoaderException e) {
	    Fehlermeldung f = new Fehlermeldung("ZRSeite : BILD : Bild " + bilder[i] + 
						" nicht gefunden!");
	    ersatzbild = null;
	}                 
        return ersatzbild;
    } 

    /** Ld das Bild */
    private void ladeBild() {
	try {
	    bild=Loader.ladeBild(URLbild);
	}
	catch (LoaderException e) {             
	    if (MadScape.TRACE) System.out.println("ZRSeite : BILD : " + URLbild + "nicht gefunden, lade Ersatzbild!");
	    bild=ladeersatzbild();
	}
    }

    /** Konstruktor zum Erzeugen eines neues Bild - Elementes . <br>
	Sorgt fr das Laden des Bildes. 
	@param absoluteURL die absolute URL ohne die Seite
	@param URLbild das zu ladende Bild 
	@param attribute die Attribute des Bildes 
	@param breite die relative Breite des Bildes
	@param hoehe die relative Hhe des Bildes
	@param ersatzbild das zusetzende Ersatzbild
    */

    /*public Bild(String absoluteURL, String URLbild, Attribute attribute,
		  ImageSize breite, ImageSize hoehe) {
	  typ             = BILD;
	  this.URLbild    = ermittleBildURL(absoluteURL, URLbild);
	  this.attribute  = attribute;*/
 
    public Bild(int ausrichtung, String absoluteURL, String URLbild, Attribute attribute, int paraausr,
		ImageSize breite, ImageSize hoehe) {
	typ             = BILD;
	this.URLbild    = ermittleBildURL(absoluteURL, URLbild);
	this.attribute  = attribute;
        this.ausrichtung = ausrichtung;

        if ((ausrichtung != 1) && (ausrichtung != 2) && (paraausr == MITTEL)) {
           bildzentriert = true; 
        }                          	
	
        ladeBild();
	
	// Finde heraus, ob die Groesse des Bildes angepasst werden muss
	// derzeitige Groesse des Bildes in Pixeln feststellen
	this.breite = bild.getWidth(null);
	this.hoehe  = bild.getHeight(null);

	if (breite instanceof Absolut) {
	    if (breite.getvalue() != 0) {
		this.breite = breite.getvalue();
	    }
	}

	if (hoehe instanceof Absolut) {
	    if (hoehe.getvalue() != 0) {
		this.hoehe  = hoehe.getvalue();
	    }
	} 

	if (breite instanceof Percent) {
	    if (breite.getvalue() != 0) {
		this.breite = breite.getvalue();
		istprozent  = true;
	    }
	}

	if (hoehe instanceof Percent) {
	    if (hoehe.getvalue() != 0) {
		this.hoehe = hoehe.getvalue();
		istprozent = true;
	    }
	}
	if (MadScape.TRACE) testausgabe();
    }
    
    /** Testausgabe fr das Element */
    public void testausgabe() {
	ausgabe("Bild");
	System.out.println("URL des Bildes : " + URLbild + " breite : "
			   + breite + " hoehe : " + hoehe);
    }
}





