package MadScape.Zwischenrepraesentation;

import java.awt.*;

/** Klasse zur Verwaltung der Attribute der Zwischelemente.
    @author David Diestel
    @author Alexander Tobis
*/
public class Attribute implements Cloneable{

    /** true, kein Zeilenumbruch */
    private boolean keinumbruch = false;

    /** true, ist Verweis */
    private boolean verweis = false;
    
    /** Zieladresse des Verweises, bzw. des Ankers. */
    private String verweistext = "";

    /** true, ist ein Anker */
    private boolean anker = false;

    /** true, ist Teil eines Listeneintrages */
    private boolean listeneintrag = false;

    /** true, ist Anfang eines Listeneintrages */
    private boolean ersterlisteneintrag = false;

    /** zaehlt, in der wievielten Unterliste sich der Listeneintrag befindet */
    private int listenzaehler = 0;
    
    /** gibt den Bullet-Typ des Listeneintrages an <br>
	0 = keine Liste <br>
	1 = square <br>
	2 = circle <br>
	3 = disc
        */
    private int listentyp = 0;

    /**	Die verwendete Schrift und deren Attribute */
    private Schrift schrift;

    /** Die Farbe der Schrift */
    private Color farbe;

    /** true, Wort wird unterstrichen */
    private boolean unterstrichen = false;

/* ------------------------------------------- */
/* Methodendeklaration                         */
/* ------------------------------------------- */

    /** true, wenn kein Umbruch erfolgen soll */
    public boolean istkeinumbruch(){
	return keinumbruch;
    }
      
    /** true, Element ist ein Verweis */
    public  boolean istverweis() {
	return verweis;
    }

    /** Liefert die URL des Verweises */
    public  String gibverweistext() {
	return verweistext;
    }

    /** true, Element ist ein Anker */
    public  boolean istanker() {
	return anker;
    }

    /** true, Element ist ein Listeneintrag */
    public  boolean istlisteneintrag() {
	return listeneintrag;
    }

    /** true, Element ist das erste Element eines Listeneintrages */
    public  boolean istersterlisteneintrag() {
	return ersterlisteneintrag;
    }

    /** int, gibt an in der wievielten Unterliste sich das Element 
	befindet Listenzaehler fngt bei 0 an. */
    public  int giblistenzaehler() {
	return listenzaehler;
    }
    
    /** gibt den Bullet-Typ des Listeneintrages an <br>
	0 = keine Liste <br>
	1 = square <br>
	2 = circle <br>
	3 = disc  */
    public  int giblistentyp() {
 	return listentyp;
    }

    /** gibt das Schrift-Objekt zurueck  */
    public Schrift gibschrift() {
	return schrift;
    }

    /** gibt das Farb-Objekt zurueck */
    public Color gibfarbe() {
	return farbe;
    }

    /** true, Wort ist unterstrichen */
    public boolean istunterstrichen() {
      return unterstrichen;
    }

    /** setzt die Schrift
        @param schrift die Schrift die gesetzt werden soll */
    public void setzeschrift(Schrift schrift) {
	this.schrift = schrift;
    }

    /** setzt das Attribut unterstrichen
        @param unterstrichen true, unterstrichen 
    */
    public void setzeunterstrichen(boolean unterstrichen) {
	this.unterstrichen=unterstrichen;
    }

    /** Setzt das Attribut anker
	@param anker, true das Element ist Anker 
    */
    public void setzeanker(boolean anker) {
	this.anker = anker;
    }

    /** Setzt den Attribut verweis
	@param verweis, true das Element ist Verweis.
    */
    public void setzeverweis(boolean verweis) {
	this.verweis = verweis;
    }

    /** Setzt den Verweistext
	@param verweistext der zu setzende Verweistext.
    */
    public void setzeverweistext(String verweistext) {
	this.verweistext = verweistext;
    }

    /** handelt es sich um einen Listeneintrag
	@param listeneintrag ,true es handelt sich um Listeneintraege. */
    public void setzelisteneintrag(boolean listeneintrag){
	this.listeneintrag = listeneintrag;
    }
    
    /** zeigt an, um die wievielte Unterliste es sich handelt 
	@param listenzaehler ,die wievielte Unterliste */
    public void setzelistenzaehler(int listenzaehler){
	this.listenzaehler = listenzaehler;
    }	

    /** Setzt den Listentyp der Liste 
	@param listentyp der zu setzende Listentyp */
    public void setzelistentyp(int listentyp) {
	this.listentyp =listentyp;
    }

    /** Setzt ersterlisteneintrag.
	@param ersterlisteneintrag true, ist erster Eintrag einer Liste
    */
    public void setzeersterlisteneintrag(boolean ersterlisteneintrag) {
	this.ersterlisteneintrag=ersterlisteneintrag;
    }
    

    /** gibt an, ob es einen Zeilenumbruch geben darf
        @param keinumbruch true, es darf einen Zeilenumbruch geben */
    public void setzekeinumbruch(boolean keinumbruch){
	this.keinumbruch = keinumbruch;
    }
    
    /** clont das Objekt, jedoch nicht die Schrift und die Farbe */
    public Object clone() {
	try {
	    return super.clone();
	}
	catch (CloneNotSupportedException e) {
	    throw new InternalError(e.getMessage()); 
	}
	
    }
   
    /** Liefert neues Attribute-Objekt zurck, das mit den Werten des 
	uebergebenen initialisiert wird.
	<P>
	Achtung : Schrift wird geklont <br>
	          Farbe wird nicht geklont
	@param attr altes Attribute Objekt, dessen Attribute kopiert werden
	            sollen
    */
    public Attribute(Attribute attr) {
	keinumbruch	    = attr.keinumbruch;
	verweis             = attr.verweis;
	verweistext         = attr.verweistext;
	anker               = attr.anker;
	listeneintrag       = attr.listeneintrag;
	ersterlisteneintrag = attr.ersterlisteneintrag;
	listenzaehler       = attr.listenzaehler;
	listentyp           = attr.listentyp;
	unterstrichen       = attr.unterstrichen;
	schrift             = (Schrift)attr.schrift.clone();
	farbe               = attr.farbe;
    }

    /** Liefert neues Attribute-Objekt zurck, das mit den Werten des 
	uebergebenen initialisiert wird.
	<P>
	Achtung : Schrift wird geklont <br>
	@param attr  altes Attribute Objekt, dessen Attribute kopiert werden
	             sollen
	@param farbe neues Farb-Objekt des Attributes
    */
    public Attribute(Attribute attr, Color farbe) {
	keinumbruch	    = attr.keinumbruch;
	verweis             = attr.verweis;
	verweistext         = attr.verweistext;
	anker               = attr.anker;
	listeneintrag       = attr.listeneintrag;
	ersterlisteneintrag = attr.ersterlisteneintrag;
	listenzaehler       = attr.listenzaehler;
	listentyp           = attr.listentyp;
	unterstrichen       = attr.unterstrichen;
	schrift             = new Schrift(attr.schrift.getName(),
				  attr.schrift.getStyle(),
				  attr.schrift.getSize());
	//(Schrift)attr.schrift.clone();
	this.farbe          = farbe;
    }
    
  /** Liefert neues Attribute-Objekt zurck, das mit den Werten des 
	uebergebenen initialisiert wird.
	<P>
	Achtung : Schrift wird geklont <br>
	@param attr    ,altes Attribute Objekt, dessen Attribute kopiert werden
	                sollen
	@param schrift ,die zusetzende Schrift des neuen Attribute-Objekts
    */
    public Attribute(Attribute attr, Schrift schrift) {
	keinumbruch	    = attr.keinumbruch;
	verweis             = attr.verweis;
	verweistext         = attr.verweistext;
	anker               = attr.anker;
	listeneintrag       = attr.listeneintrag;
	ersterlisteneintrag = attr.ersterlisteneintrag;
	listenzaehler       = attr.listenzaehler;
	listentyp           = attr.listentyp;
	unterstrichen       = attr.unterstrichen;
	this.schrift        = schrift;
					
	//(Schrift)attr.schrift.clone();
	this.farbe          = farbe;
    }

    /** Liefert neues Attribute-Objekt zurck, das mit den Werten des 
	uebergebenen initialisiert wird.
	<p>
	@param attr    , altes Attribute Objekt, dessen Attribute kopiert 
	                 werden sollen
	@param schrift , die zusetzende Schrift des neuen Attribute-Objekts
	@param farbe   , die Farbe die gesetzt werden soll
    */
  public Attribute(Attribute attr, Color farbe, Schrift schrift) {
    keinumbruch	    = attr.keinumbruch;
    verweis             = attr.verweis;
    verweistext         = attr.verweistext;
    anker               = attr.anker;
    listeneintrag       = attr.listeneintrag;
    ersterlisteneintrag = attr.ersterlisteneintrag;
    listenzaehler       = attr.listenzaehler;
    listentyp           = attr.listentyp;
    unterstrichen       = attr.unterstrichen;
    this.schrift        = schrift;
    this.farbe          = farbe;
  }

  /** Erzeugt ein neues Attribute-Objekt.
      @param schrift Font, die das Objekt haben soll 
      @param farbe   Color, die das Objekt haben soll
  */
  public Attribute(Font schrift, Color farbe) {
    this.schrift = new Schrift(schrift.getName(),
			       schrift.getStyle(),
			       schrift.getSize());
    this.farbe   = farbe;
  }   
    
}

