
package MadScape;

/**
 * Die Voreinstellungen des Browsers fr Font und Farben
 * @author Andr Vratislavsky
 * @author Max Haustein
 */

import java.awt.*;
import java.net.URL;

public class Voreinstellungen {

Font zeichensatz;
Color schriftfarbe, linkfarbe, hintergrundfarbe;
String home, hilfeadres; // die Heimatadresse
//------------------------------------------------------------------------
	/**
	 * mit Standartwerten konstruieren
	 */
	public Voreinstellungen () {
		zeichensatz = new Font ("Serif",Font.PLAIN,12);
		schriftfarbe = Color.black;
		linkfarbe = Color.blue;
		hintergrundfarbe = Color.lightGray;
		home = "http://www.inf.fu-berlin.de/~vratisla/swp/index.html";
		hilfeadres = "http://www.inf.fu-berlin.de/~vratisla/swp/hilfe.html";
	}
//------------------------------------------------------------------------
	/**
	 * liefert den momentan eingestellten Zeichensatz
	 */
	public Font holeZeichensatz() {
		return zeichensatz;
	}
//------------------------------------------------------------------------
	/**
	 * liefert die aktuelle Schriftfarbe
	 */
	public Color holeSchriftfarbe() {
		return schriftfarbe;
	}
//------------------------------------------------------------------------
	/**
	 * liefert die aktuelle Schriftfarbe fr Links
	 */
	public Color holeLinkfarbe() {
		return linkfarbe;
	}
//------------------------------------------------------------------------
	/**
	 * liefert die aktuelle Farbe fr den Hintergrund
	 */
	public Color holeHintergrundfarbe() {
		return hintergrundfarbe;
	}
//------------------------------------------------------------------------
	/**
	 * liefert die home-Adresse als String
	 */
	public String holeHome() {
		return home;
	}
//------------------------------------------------------------------------
	/**
	 * liefert die hilfe-Adresse als String
	 */
	public String holeHilfe() {
		return hilfeadres;
	}
//------------------------------------------------------------------------
	/**
	 * setze die home-Adresse als String
	 */
	public void setzeHome(String homeString) {
		home = homeString;
	}
//------------------------------------------------------------------------
	/**
	 * setzt einen neuen Standartzeichensatz
	 */
	public void setzeZeichensatz(Font f) {
		zeichensatz = f;
	}
//------------------------------------------------------------------------
	/**
	 * setzt eine neue Farbe fr den Text
	 */
	public void setzeTextfarbe(Color c) {
		schriftfarbe = c;
	}
//------------------------------------------------------------------------
	/**
	 * setzt eine neue Textfarbe fr die Links
	 */
	public void setzeLinkfarbe(Color c) {
		linkfarbe = c;
	}
//------------------------------------------------------------------------
	/**
	 * setzt eine neue Hintergrundfarbe
	 */
	public void setzeHintergrundfarbe(Color c) {
		hintergrundfarbe = c;
	}
//------------------------------------------------------------------------
}
