
package MadScape;

import MadScape.GUI.*;
import java.awt.*;

/**
 * Die Hauptklasse mit der Main-Methode. 
 * Hier wird das Programm gestartet.
 * @author Andr Vratislavsky
 * @author Max Haustein
 */
public class MadScape {
	
	// Fehlermeldungen ausgeben?
	public static boolean TRACE = Boolean.getBoolean("MadScape.TRACE");
	
	/**
	 * Die Main Methode. Sie fragt die Bildschirmauflsung ab, 
	 * erzeugt einen Startdialog und bereitet ein BrowserFenster
	 * vor, das dann vom geschlossenen Startdialog geffnet wird
	 */
	 
	public static void main(String[] args) {
		
		if (TRACE) System.out.println("\nStatusausgabe aktiviert.\n");
		else       System.out.println("\nStatusausgabe deaktiviert.\n");
		
		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		int b = screen.width;
		int h = screen.height;
		
		// Browser erzeugen
		BrowserFenster bf = new BrowserFenster(screen);
		bf.setTitle("MadScape");
		
		// und mittig positionieren
		bf.setSize((int)(screen.width*0.50),(int)(screen.height*0.80));
		bf.setLocation ((b-bf.getSize().width)/2, (h-bf.getSize().height)/2);
		// bf.setVisible(true); // das macht der Startdialog
		// bf.validate();
	 	
	 	// Start-Dialog erzeugen
	 	StartDialog start = new StartDialog(bf);
	 	start.setLocation((b-start.getSize().width)/2,(h-start.getSize().height)/2);
	 	start.setVisible(true);
	 	start.toFront(); // damit er sich gegen eventuelle Fehlermeldungen
	 	                 // durchsetzt und der KeyListener funkioniert (wohl nur unter W95)
	 }
}
