
package MadScape;

import java.io.*;  // fr den InputStream
import java.net.*; // fr die URL
import java.awt.*; // fr das Image

/**
 * Der Loader ist zustndig fr das <br><br>
 * <b>Erzeugen eines InputStreams</b> aus einer 
 * URL (als URL-Objekt oder als String) fr den Parser, 
 * <br><br> und fr das <br><br>
 * <b>Laden einer Bilddatei</b> zu einer gegebenen URL (ebenfalls als
 * URL oder als String geben). <br><br>
 * Das Laden von Bilder wird gecachet (z.Zt. sicherheitshalber nur mit 
 * 10 Bildern). Alle URLs, die als Strings bergeben werden, mssen
 * absolute URLs darstellen.
 */

public class Loader {

static int cacheSize = 10; // wer wei, wie gro die Bilder sind...

static CacheBild[] cache = new CacheBild[cacheSize];
static int cachePointer=0; // Array wird zyklisch betrachtet
                           // Pointer zeigt auf Position fr neuen Eintrag

//------------------------------------------------------------------------
// METHODEN
//------------------------------------------------------------------------
	/**
	 * Ein Bild aus dem Standard-Bildverzeichnis
	 */
	public static Image ladeLokalesBild (String bildName) throws LoaderException {
		
		// erstmal sehen, ob wir das Bild schon haben:
		Image image = holeAusCache(bildName);
		// falls gefunden -> fertig.
		if (image!=null) return image;
		
		// sonst Bild suchen: aktuelles Verzeichnis finden
		Class c=null;
		try{ c = Class.forName("MadScape.Loader");}
		catch(Exception e) {
                        throw new LoaderException ("Lokales Bild wurde nicht gefunden. (forName())");
		}

		// URL konstruieren
		URL url;
		String sep = System.getProperty("file.separator");
		url = c.getResource(".." + sep + "MadPics" + sep + bildName);
		
		if (url==null) throw new LoaderException("Lokales Bild wurde nicht gefunden. (URL falsch)");
				
		// URL des lokalen Bildes gefunden, Bild laden:
		image = Toolkit.getDefaultToolkit().getImage( url );
		
		// auf das Bild warten:
		// nicht schn, aber der MediaTracker braucht einen Component,
		// in den das Bild "eventuell" (Zitat sun-Tutorial) gezeichnet 
		// werden wird, haben wir hier nicht, also so:
		MediaTracker tracker = new MediaTracker(new Canvas());
		tracker.addImage(image,0);
		
		if (MadScape.TRACE) System.out.println("LOADER: Ein LOKALES Bild wird geladen...");
		
		try {tracker.waitForID(0);}
		catch (InterruptedException e) {
			throw new LoaderException ("Lokales Bild wurde nicht gefunden. (Media-Tracker)");
		}
		
		// haben wir da tatschlich ein Bild geladen?
		if (tracker.isErrorAny()) throw new LoaderException ("Kein Bild.");
		
		if (MadScape.TRACE) System.out.println("LOADER: LOKALES Bild ist da.");
		
		// neues Bild in Cache eintragen:
		inCacheEintragen(image, bildName);
		
		return image;

	}
	
	/**
	 * Erzeugt ein Bild von einer absoluten URL, die als String
	 * gegeben ist. Es wird gewartet, bis das Bild vollstndig geladen
	 * wurde (MediaTracker).
	 * @return das neue Bild (Image)
	 * @param urlString die URL des Bildes als String
	 * @exception LoaderException falls beim Laden irgendein Fehler
	 *            aufgetreten ist (nheres dann ber .getMessage()).
	 */
	public static Image ladeBild (String urlString) throws LoaderException {
		
		// erstmal sehen, ob wir das Bild schon haben:
		Image image = holeAusCache(urlString);
		// falls gefunden -> fertig.
		if (image!=null) return image;
		
		// versuchen, den String in eine URL umzuwandeln 
		URL url=null;
		try {url = new URL(urlString);}
		catch (MalformedURLException mfu) {
			throw new LoaderException ("Falsche URL fr ein Bild.");}
		
		image = Toolkit.getDefaultToolkit().getImage(url);
		
		// auf das Bild warten:
		
		// nicht schn, aber der MediaTracker braucht einen Component,
		// in den das Bild "eventuell" (Zitat sun-Tutorial) gezeichnet 
		// werden wird, haben wir hier nicht, also so:
		MediaTracker tracker = new MediaTracker(new Canvas());
		tracker.addImage(image,0);
		
		if (MadScape.TRACE) System.out.println("LOADER: Ein Bild wird geladen...");
		
		try {tracker.waitForID(0);}
		catch (InterruptedException e) {
			throw new LoaderException ("Fehler beim Laden eines Bildes.");
		}
		
		// haben wir da tatschlich ein Bild geladen?
		if (tracker.isErrorAny()) throw new LoaderException ("Kein Bild.");
		
		if (MadScape.TRACE) System.out.println("LOADER: Bild ist da.");
		
		// neues Bild in Cache eintragen:
		inCacheEintragen(image, urlString);
		
		return image;
	}
//------------------------------------------------------------------------
	/**
	 * Erzeugt ein Bild von einer absoluten URL. Es wird 
	 * gewartet, bis das Bild vollstndig geladen wurde (MediaTracker).
	 * @return das neue Bild (Image)
	 * @param url die URL des Bildes (als URL-Objekt)
	 * @exception LoaderException falls beim Laden irgendein Fehler
	 *            aufgetreten ist (nheres dann ber .getMessage()).
	 */
	public static Image ladeBild (URL url) throws LoaderException {
		
		// erstmal sehen, ob wir das Bild schon haben
		Image image = holeAusCache(url.toString());
		// falls gefunden -> fertig.
		if (image!=null) return image;
		
		image = Toolkit.getDefaultToolkit().getImage(url);
		// auf das Bild warten:
		
		// nicht schn, aber der MediaTracker braucht einen Component,
		// in den das Bild "eventuell" (Zitat sun-Tutorial) gezeichnet 
		// werden wird, haben wir hier nicht, also so:
		MediaTracker tracker = new MediaTracker(new Canvas());
		tracker.addImage(image,0);
	   	
	   	if (MadScape.TRACE) System.out.println("LOADER: Ein Bild wird geladen...");
	   	
	   	try {tracker.waitForID(0);}
	   	catch (InterruptedException e) {
	   		throw new LoaderException ("Fehler beim Laden eines Bildes.");
	   	}
	   	
	   	// haben wir da tatschlich ein Bild geladen?
	   	if (tracker.isErrorAny()) throw new LoaderException ("Da war kein Bild.");
		
		if (MadScape.TRACE) System.out.println("LOADER: Bild ist da.");
		
		// neues Bild in Cache eintragen:
		inCacheEintragen(image, url.toString());
		
		return image;
	}
//------------------------------------------------------------------------
	/**
	 * Erzeugt einen InputStream von einer absoluten URL, die 
	 * als String gegeben ist.
	 * @return InputStream
	 * @param url die URL als String
 	 * @exception MalformedURLException falls ungltige URL
	 * @exception IOException falls der InputStream nicht erzeugt 
	 *    werden konnte
	 */
	public static InputStream ladeHTML (String urlString) throws IOException, MalformedURLException {
			
		URL url = new URL(urlString); // ggf. wird Exception geworfen
			
		// den Stream erzeugen:
		return url.openStream();      // ggf. wird Exception geworfen
	}
//------------------------------------------------------------------------
	/**
	 * Erzeugt einen InputStream von einer absoluten URL.
	 * @return InputStream
	 * @param url die URL (als URL-Objekt)
	 * @exception IOException falls der InputStream nicht erzeugt 
	 *    werden konnte
	 */
	public static InputStream ladeHTML (URL url) throws IOException {
		// Stream erzeugen:
		return url.openStream();      // ggf. wird Exception geworfen
	}
//------------------------------------------------------------------------
	// Bild im Cache suchen, falls nicht da, null-Pointer
	static Image holeAusCache (String ort) {
		int i=0;
		CacheBild temp;
		while (i<cache.length) {
			temp = cache[i];
			if (temp!=null && temp.gleicheURL(ort)) {
				if (MadScape.TRACE) System.out.println("LOADER: Cache-Hit.");
				return temp.holeBild();
			}
			i++;
		}
		return null;
	}
//------------------------------------------------------------------------
	// neues CacheBild in den Cache schreiben, Index zyklisch (modulo)
	// erhhen
	static void inCacheEintragen(Image b, String s) {
		cache[cachePointer] = new CacheBild(b,s);
		cachePointer = (cachePointer+1) % cache.length;
	}
//------------------------------------------------------------------------
}