
package MadScape.GUI;

import java.net.URL;
import java.util.Vector;
import MadScape.GUI.*;
import MadScape.MadScape;
//------------------------------------------------------------------------
/**
 * History fr die Funktion der Buttons vor/zurck. Nimmt neu angewhlte
 * URLs als Strings entgegen und liefert der History entsprechend die 
 * vorhergehende bzw. die folgende URL (als String).
 * 
 * @author Andr Vratislavsky
 * @author Max Haustein
 */
public class Verlauf {
//------------------------------------------------------------------------
// ATTRIBUTE
//------------------------------------------------------------------------
	// Ein Vector von Strings (den URLs)
	Vector urls;
	
	// Der Zeiger auf die aktuelle Position.
	int zeiger;
	
	// Das BrowserFenster, zu dem der Verlauf gehrt
	BrowserFenster bf;

//------------------------------------------------------------------------
// KONSTRUKTOR
//------------------------------------------------------------------------
	/**
	 * Erzeugt einen neuen leeren Verlauf
	 * @param das BrowserFenster, zu dem der Verlauf gehrt
	 * (damit die Buttons vor/zurck en-/disabled werden knnen)
	 */
	public Verlauf (BrowserFenster browser) {
		urls = new Vector(10);  // Index 0..9
		zeiger = -1;
		bf = browser;
	}

//------------------------------------------------------------------------
// METHODEN
//------------------------------------------------------------------------
	/**
	 * Die vorhergehende URL wird als String geliefert. Falls es keine
	 * vorhergehenden URL mehr gibt, wird der "zurck"-Button gesperrt. Der 
	 * "vor"-Button wird freigegeben.
	 * @return den String mit der letzten URL
	 */
	public String letzteURL ( ) {
		String ret;  // der Rckgabewert
		zeiger--;

		if (zeiger <= 0) bf.aktiviereZurueck(false);
		bf.aktiviereVor(true);
		
		// berprfung sollte eigentlich nicht ntig sein:
		if (zeiger<urls.size() && zeiger>=0)
			 ret = new String ( (String) urls.elementAt(zeiger) );
		else ret = "";
		return ret;
	}
//------------------------------------------------------------------------
	// Alle URLs mit Index > Zeiger werden gelscht.
	// damit ist die URL an Position "Index" die letzte im Vektor
	private void loescheFolgende ( ) {
		// beim Lschen im Vektor rcken die folgenden Elemente auf
		while ( urls.size() > zeiger+1 ) {
			urls.removeElementAt(zeiger+1);
		}
	}
//------------------------------------------------------------------------
	/**
	 * Die nachfolgende URL wird als String geliefert. Falls es keine
	 * weiteren nachfolgenden URLs gibt, wird der "vor"-Button gesperrt. 
	 * Der "zurck"-Button wird freigegeben.
	 * @return den String mit der nchsten URL
	 */
	public String naechsteURL ( ) {
		zeiger++;
		String ret;
		
		if (zeiger>=urls.size()-1) bf.aktiviereVor(false);
		bf.aktiviereZurueck(true);
		
		if (zeiger<urls.size() && zeiger>=0)
			 ret = new String ( (String) urls.elementAt(zeiger));
		else ret = "";
		return ret;
	}
//------------------------------------------------------------------------
	/**
	 * Bei Anwhlen eines Links oder manueller Eingabe einer URL wird 
	 * die neue URL bernommen.  Der "vor"-Button wird gesperrt. 
	 * Befindet man sich nicht an der letzten Position, so werden allen 
	 * folgenden Eintrge gelscht.<br>
	 * Wird bei gleichbleibender URL mehrfach der laden-Button bettigt, 
	 * wird die URL nur einmal aufgenommen (nur eine von der aktuellen URL
	 * verschiedene URL wird aufgenommen). Damit hat der laden-Button
	 * eine "reload-Funktion".
	 *
	 * @param u die neue aktuelle URL als String
	 */
	public void neueURL (String u) {
		// Falls es sich um eine neue URL handelt:
		
		boolean neueURL  = false;
		
		if (zeiger>=0 && zeiger<urls.size())
			// gltiger Zeiger -> mit vektor vergleichen
			neueURL = !u.equals(urls.elementAt(zeiger));
			// sonst prfen, ob dies die erste URL:
		else neueURL = zeiger==-1;

		if (neueURL) {
		    
			loescheFolgende();
			zeiger++;
			// Kopie des Strings anfertigen
			// um interessanten Effekten vorzubeugen
			String s = new String (u);
			urls.addElement(s);
			
			if (zeiger>0) bf.aktiviereZurueck(true);
			bf.aktiviereVor(false);
		}
	}
//------------------------------------------------------------------------
	// Testausgabe
	public void testausgabe() {
		if (MadScape.TRACE) {
			System.out.println("-----------------");
			System.out.println("aktueller Status (Verlauf)");
			System.out.println("Zeiger: "+zeiger);
			for (int i=0; i<urls.size(); i++) {
				System.out.println("Verlauf "+i+": "+urls.elementAt(i));
			}
			System.out.println("-----------------");
		}
	}
//------------------------------------------------------------------------
}