
package MadScape.GUI;

import java.awt.*;
import java.awt.event.*;
import MadScape.*;
import java.net.*;
import java.io.*;

/**
 * Die Bildebene fr den Startdialog.
 * @author Max Haustein
 */
public class StartDialogCanvas extends Canvas implements Runnable {
//------------------------------------------------------------------------
// ATTRIBUTE
//------------------------------------------------------------------------
	MediaTracker tracker; // nur frs lokale Bildladen
	Thread Timer;         // Animation des Lauftextes
	int off1, off2;       // position des Stings
	Image bild;           // das Titelbild
	int x,y;              // Breite und Hhe des Bildes
	
	String namen;         // der Lauftext
	Font font;
	int breite;           // berechnetet Breite des Lauftextes
	
	StartDialog sd;       // der Dialog, in dem sich das Canvas befindet
	
	Frame parent;         // letztendlich das BrowserFenster, da sich ein
	                      // Fenster ohne Titelleiste usw. nur in
	                      // Beziehnung zu einem Frame erzeugen lt

	private Image imageBuffer; // Offscreen Image
	private Graphics gImg;     // + Offscreen Graphics fr die Animation
	
//------------------------------------------------------------------------
// KONSTRUKTOR
//------------------------------------------------------------------------
	/**
	 * erzeugt eine Bildflche fr den Startdialog
	 * @param Startdialog s - der Dialog, fr den das Canvas bestimmt ist
	 * @param Frame f - letztendlich das BrowserFenster, um es anzeigen
	 *        zu knnen, wenn der Startdialog vom MouseListener gelscht
	 *        wird
	 */
	public StartDialogCanvas(StartDialog s, Frame f){
		
		sd = s;       // Zeiger bernehmen
		parent = f;
		// Bild laden:
		bild=null;
		try {
			bild = Loader.ladeLokalesBild("titel.gif");
		} catch (LoaderException le) {
			// keine Titelbild -> kein Startdialog...
			parent.setVisible(true);
			sd.dispose();
			Fehlermeldung err = new Fehlermeldung("Startbild: "+le.getMessage() );
		}
		
		// Lauftext definieren und Breite berechnen
		namen = "Das Team: Zwischenreprsentation: Alexander Tobis, David Diestel, Mario Meier, Philipp Metzner  -  Formatierte Seite: Andr Baradari, Alexander Knabner, Alexander Lning, Ronny Manthey, Stefan Strigler, Thomas Sundermann  -  GUI: Max Haustein, Andr Vratislavsky  -  Seelischer Beistand: Christof Schultz  -  ";
		font = new Font ("Arial",Font.BOLD,12);
		FontMetrics fm = getFontMetrics(font);
		breite = fm.stringWidth(namen);
		
		// Fenstergre anpassen und Positionen des Lauftexts bestimmen
		x=bild.getWidth(this);
		y=bild.getHeight(this);		
		off1=x;
		off2=off1+breite;
		setSize(x,y);
		
		// bei Mausklick Fenster schlieen und Browser anzeigen
		addMouseListener(new MouseAdapter() {
			public void mouseReleased(MouseEvent e){
				sd.dispose();
				parent.setVisible(true);
		}});
		
		// die Animation starten
		Timer=new Thread(this);
		Timer.start();
	}
//------------------------------------------------------------------------
	public void stop() {Timer.stop();}
//------------------------------------------------------------------------
	public void run() {
		while (true) {
			try{Thread.currentThread().sleep(30);}
			catch(InterruptedException e){}
			repaint();
		}
	}
//------------------------------------------------------------------------
	public void update(Graphics g) {paint(g);}
//------------------------------------------------------------------------
	public void paint(Graphics g) {
		
		// falls ntig, Offscreen-Image & -Graphics
		if (imageBuffer==null || gImg==null) {
			imageBuffer=createImage(x,y);
			gImg=imageBuffer.getGraphics();
		}
		
		// Lauftext verschieben
		off1-=3;
		if (off1<-breite) off1=off2+breite;
		off2-=3;
		if (off2<-breite) off2=off1+breite;
		
		// Bild, String und Rahmen zeichnen
		gImg.drawImage(bild, 0, 0, this);
		gImg.setColor(Color.lightGray);
		gImg.setFont(font);
		gImg.drawString(namen, off1, y-10);
		gImg.drawString(namen, off2, y-10);
		gImg.setColor(Color.white);
		gImg.drawRect(0, 0, x-1, y-1);
		gImg.drawRect(1, 1, x-3, y-3);
		
		// und Offscreen Bild ins Canvas zeichnen
		g.drawImage(imageBuffer, 0, 0, null);
	}
//------------------------------------------------------------------------
}