
package MadScape.GUI;

import java.awt.*;    
import java.awt.event.*;
import java.awt.Color.*;
import java.awt.event.*;
import MadScape.*;

/**
 * Ein Startfenster fr den Browser.
 * 
 * @author Andr Vratislavsky
 * @author Max Haustein
 */
public class StartDialog extends Window {

StartDialogCanvas can;  // die Bildflche
Frame f; // Der "Inhaber" des Windows (hier das BrowserFenster)

//------------------------------------------------------------------------
// KONSTRUKTOR
//------------------------------------------------------------------------
	/**
	 * Erzeugt ein Startfenster fr ein Browserfenster f.
	 * @param f - das BrowserFenster, um es anzeigen
	 *        zu knnen, wenn der Startdialog geschlossen wird
	 */
	public StartDialog(Frame frame) {
		super(frame);
		f=frame;
		
		// Bildflche erzeugen
		can = new StartDialogCanvas(this, frame);
		add(can);
		setSize(can.getSize().width, can.getSize().height);
		
		// bei Tastendruck Fenster schlieen und Browser anzeigen
		addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent e){	
				dispose();
				f.setVisible(true);
		}});
	}
//------------------------------------------------------------------------	
}