
package MadScape.GUI;

import java.awt.*;    
import java.awt.event.*;

import java.io.*;
import java.net.*;

import MadScape.*;
import MadScape.Zwischenrepraesentation.*;
import MadScape.FormatierteSeite.*;
import parser.*;
import parsetree.*;

/**
 * HandleAction verwaltet die Menuereignisse
 * @author Max Haustein
 * @author Andr Vratislavsky
 */
public class HandleAction implements ActionListener {	

	BrowserFenster brFenster;
	int menuIndex;
	
	/**
	 * Die Menuereignisverwaltung instanzieren.
	 * @param bFenster das dazugehrige BrowserFenster
	 * @param menuIndex die Nummer des Menuitems
	 */
	public HandleAction(BrowserFenster bFenster, int menuIndex) {
		this.brFenster = bFenster;
		this.menuIndex = menuIndex;
	}
	
	public void actionPerformed(ActionEvent e){  
	
		switch(menuIndex){		
			
		case 1:{								// Neues Fenster
			if (MadScape.TRACE) System.out.println("Menu Neues Fenster");
			Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
	 		BrowserFenster nbf = new BrowserFenster(screen);
			int x = brFenster.getLocation().x+25;
			int y = brFenster.getLocation().y+25;
			nbf.setBounds(x,y,(int)(screen.width*0.50),(int)(screen.height*0.80));
			nbf.setTitle("MadScape");
			nbf.setVisible(true);
			break;
		};
		case 2:{								// Beenden
			System.exit(0);
			break;
		};
		case 3:{								// Fenster schlieen
			brFenster.dispose();
			if (brFenster.fensterAnzahl==1) System.exit(0);
			brFenster.fensterAnzahl--;
			break;
		};
		case 4:{								// Laden
			if (MadScape.TRACE) System.out.println("Menu Laden");
			brFenster.load();
			break;
		};
		case 5:{								// Zurck
			if (MadScape.TRACE) System.out.println("Menu Zurck");
			brFenster.zurueck();
			break;
		};
		case 6:{								// Vor
			if (MadScape.TRACE) System.out.println("Menu Vor");
			brFenster.vor();
			break;
		};
		case 7:{								// Heim
			if (MadScape.TRACE) System.out.println("Menu Heim");
			brFenster.heim();
			break;
		};
		case 8:{								// Hilfe
			if (MadScape.TRACE) System.out.println("Menu ber Madscape");
			brFenster.hilfe();
			break;
		};
		case 9:{								// Stop
			if (MadScape.TRACE) System.out.println("Menu Stop");
			brFenster.stop_load();
			break;
		};
		}
	}
	
}
