
package MadScape.GUI;

/**
 * Zeigt einen Fehlermeldung in einem extra Fenster an. 
 * <tt>extends Frame</tt> und nicht <tt>Dialog</tt>, da ein Dialog immer 
 * einen Frame braucht, zu dem er "gehrt". Wrde also von Dialog geerbt 
 * werden, knnte etwa aus der Zwischenreprsentation kein Fehler 
 * angezeigt werden.
 * @author Andr Vratislavsky
 * @author Max Haustein
 */

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import MadScape.*;

/**
 * Zeigt eine Fehlermeldung in einem Fenster an
 */
public class Fehlermeldung extends Frame {
	Label meldung;
	Button ok;
	int seriennr;
	
	// global alle Fehlermeldungen merken, um sie vor ein BrowserFenster
	// schieben zu knnen, Seriennummer fr Identifikation einer Meldung
	static Vector meldungen = new Vector(3,1); // sollten nicht viele werden
	static int seriennummer=0;
//------------------------------------------------------------------------
	/**
	 * eine neue Fehlermeldung wird angezeigt
	 * @param fehler die Fehlermeldung (als String)
	 */
	public Fehlermeldung(String fehler) {
		
		// neues Fenster mit Titel erzeugen
		super("Ein Fehler ist aufgetreten:");
		setBackground(Color.lightGray);
		
		// eindeutige Seriennummer abholen
		seriennr = seriennummer++;
		// in Fehlermeldungs-History eintragen
		meldungen.addElement(this);
		
		// damit das Fenster auch wieder zu geht
		addWindowListener(
			new WindowAdapter() {
				public void windowClosing(WindowEvent e) {
					ausListeEntfernen();
					dispose();
		}});

		// Fehlertext als Label ins Fenster:
		setLayout(new BorderLayout());
		meldung = new Label(fehler);
		
		Font font = new Font ("Arial",Font.BOLD,12);
		FontMetrics fm = getFontMetrics(font);
		int breite = Math.max(300,fm.stringWidth(fehler)+30);
		
		meldung.setFont(font);
		meldung.setAlignment(Label.CENTER);
		add("Center",meldung);
		
		// OK-Button
		ok = new Button ("OK");
		ok.addActionListener(
			new ActionListener() {
				public void actionPerformed( ActionEvent e) {
					ausListeEntfernen();
					dispose();
		}});
		
		Panel p = new Panel();
		p.add(ok); // im FlowLayout des Panels
		add("South",p); // im Fenster
		
		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		breite = Math.min (breite, (int)(screen.width*0.7));
		setBounds( (screen.width-breite)/2,screen.height/2-50,breite,100);
		setVisible(true);
		validate();
	}
//------------------------------------------------------------------------
	// lscht sich aus der globalen "History" von Fehlermeldungen
	// erster Versuch war lschen ber removeElement(this), was aber 
	// trotz berschreiben der "equals(Object o)"-Methode von Object 
	// nicht funktioniert hat.
	void ausListeEntfernen () {
		for (int i=0; i<meldungen.size(); i++)
			if ( ((Fehlermeldung)(meldungen.elementAt(i))).seriennr == seriennr) {
				meldungen.removeElementAt(i);
				break; // die Seriennummer ist schlielich eindeutig
			}
	}	
}