
package MadScape.GUI;

import java.awt.*;
import java.awt.event.*;
import java.awt.Color.*;

import java.io.*;
import java.net.*;
import java.util.Vector;

import MadScape.*;
import MadScape.Zwischenrepraesentation.*;
import MadScape.FormatierteSeite.*;
import parser.*;
import parsetree.*;

/**
 * Ein BrowserFenster "ist" ein Browser. Das Browserfenster enthlt die
 * Steuerungsbuttons, eine Animation, die anzeigt, ob gerade eine Seite
 * geladen wird, ein Textfeld fr die URL und die Flche, in der die
 * Webseite dargestellt wird.
 * @author Andr Vratislavsky
 * @author Max Haustein
 */
public class BrowserFenster extends java.awt.Frame implements Runnable {
//------------------------------------------------------------------------
// ATTRIBUTE
//------------------------------------------------------------------------

	// Das Textfeld zur manuellen Eingabe einer neuen URL. Die Eingabe
	// wird ber den "laden"-Button besttigt. Voreinstellung: Home.
	TextField urlFeld;

	// ...und sein Inhalt
	String urlString;

	// Das Logo
	AnimiertesLogo logo;

	// Die vor der aktuellen URL besuchte URL wird angezeigt. Wurde noch
	// keine URL vorher besucht, ist der Button gesperrt.
	// Voreinstellung: gesperrt.
	ButtonZurueck zurueck_but;

	// Wurde vorher der "zurck"-Button bettigt, so wird die nchste URL
	// in der History angezeigt. Befindet man sich nicht an der letzten
	// Stelle der History (hat also URL "vor sich" in der History) und
	//  whlt einen Link an oder gibt eine URL manuell ein, so werden alle
	// folgenden URLs in der History gelscht. Der Button wird dann
	// gesperrt. Voreinstellung: gesperrt.
	ButtonVor vor_but;

	// Der Inhalt der im URL-Feld angegebenen Adresse soll im HTML-Feld
	// angezeigt werden.
	//Button laden_but;
	ButtonLaden laden_but;

	// Parsen und Umrechnen in Bild mu in Thread verpackt werden, dann
	// kann der Stop-Button den Thread anhalten.
	ButtonStop stop_but;

	// die MenuItems, die disabled werden knnen, mssen global sein
	MenuItem vor, rueck, stop;

	// Der Bereich, in dem die HTML-Seite angezeigt wird.
	BildScrollPane htmlEbene;  //=new BildScrollPane();

	// Ausgabe von Fehlern...
	Label meldung;

	// Die Menge aller Links, die auf der HTML-Seite anwhlbar sind,
	// als String. Ein Link belegt einen bestimmten rechteckigen Bereich
	// auf der Seite.
	LinkMenge links;

	AnkerMenge anker;

	// Die History fr die Buttons "vor" und "zurck".
	Verlauf verlauf;

	// Die Voreinstellungen fr Zeichensatz, Farben und Home-URL
	Voreinstellungen prefs;

	// Die URL die gerade angezeigt wird
	//URL url;

	// ActionListener
	HandleAction action;

	// Der Ladevorgang
	Thread runner;

	// Hintergrundfarbe fr die GUI
	Color hintergrund = Color.lightGray;

	// Browser-fenster_Zhler
	public static int fensterAnzahl = 0;
	
	// Erzeugen einer neuen Seite:
	InputStream ips;
 	Parser pars;
 	Page pg;
	ZRSeite zrSeite;
	Image neuesBild;

//------------------------------------------------------------------------
// KONSTRUKTOR
//------------------------------------------------------------------------
	/**
	 * Eine neues BrowserFenster instanzieren.
	 * @param screen ein Dimension-Objekt, das die Bildschirmgre enthlt
	 */
	public BrowserFenster(Dimension screen) {
		// ab jetzt gibt es ein Fenster mehr
		fensterAnzahl++;

		// Voreinstellungen und Verlauf erzeugen
		prefs = new Voreinstellungen();
		verlauf = new Verlauf(this);

		// zum Fenster schlieen
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				// noch andere Fenster offen?
				if (fensterAnzahl==1) System.exit(0);
				else { dispose(); fensterAnzahl--; };
			}
			public void windowActivated(WindowEvent we) {
				// potentielle Fehlermeldungen nach vorn schaufeln:
				Vector v = Fehlermeldung.meldungen;
				for (int i=0; i<v.size(); i++)
					((Fehlermeldung)v.elementAt(i)).toFront();
			}
		}); 

		// Fensterbreitenvernderung registrieren fr Zwischenreprsentation
		addComponentListener(new ComponentAdapter() {
			public void componentResized(ComponentEvent e) {
				if (zrSeite!=null) formatiereSeite();
			}
		});

		////////////////////////////////
		/////     Layout          //////
		////////////////////////////////
		// GridBagLayout setzen fr das Browserfenster
		GridBagLayout gridBag = new GridBagLayout();
		GridBagConstraints constraints = new GridBagConstraints();
		setLayout(gridBag);
		setBackground(hintergrund);

		////////////////////////////////
		/////     Menuleiste      //////
		////////////////////////////////
		MenuBar mbar = new MenuBar();
		setMenuBar(mbar);

		Menu datei = new Menu("Datei");	mbar.add(datei);

		MenuItem neuesFenster = new MenuItem("Neues Fenster"); datei.add(neuesFenster);
		action = new HandleAction(this,1);
		neuesFenster.addActionListener(action);

		MenuItem schliessen = new MenuItem("Fenster schlieen"); datei.add(schliessen);
		action = new HandleAction(this,3);
		schliessen.addActionListener(action);

		MenuItem allesSchliessen = new MenuItem("Beenden"); datei.add(allesSchliessen);
		action = new HandleAction(this,2);
		allesSchliessen.addActionListener(action);

		Menu ansicht = new Menu("Ansicht");	mbar.add(ansicht);

		MenuItem lade = new MenuItem("Laden"); ansicht.add(lade);
		action = new HandleAction(this,4);
		lade.addActionListener(action);

		stop = new MenuItem("Stop"); ansicht.add(stop);
		action = new HandleAction(this,9);
		stop.addActionListener(action);
		stop.setEnabled(false);

		Menu gehe = new Menu("Gehe"); mbar.add(gehe);

		rueck = new MenuItem("Zurck"); gehe.add(rueck);
		action = new HandleAction(this,5);
		rueck.addActionListener(action);
		rueck.setEnabled(false);

		vor = new MenuItem("Vor");	gehe.add(vor);
		action = new HandleAction(this,6);
		vor.addActionListener(action);
		vor.setEnabled(false);

		MenuItem heim = new MenuItem("Heim"); gehe.add(heim);
		action = new HandleAction(this,7);
		heim.addActionListener(action);

		Menu hilfe = new Menu("Hilfe");	mbar.add(hilfe);

		MenuItem ueber = new MenuItem("ber Madscape");	hilfe.add(ueber);
		action = new HandleAction(this,8);
		ueber.addActionListener(action);

		////////////////////////////////
		/////     Buttonleiste    //////
		////////////////////////////////
		Panel buttonleiste = new Panel();
		buttonleiste.setLayout(new FlowLayout(FlowLayout.LEFT));

		Image vorIcon=null;
		Image zurueckIcon=null;
		Image ladenIcon=null;
		Image stopIcon=null;

		// Bilder fr die Buttons laden:
		try {
			//String pfad = System.getProperty("user.dir");
			// unter W95 wird der Pfad leider mit \ geliefert.
			// in der Hoffnung, da kein UNIX-Verzeichnis "\" enthlt:
			//pfad = pfad.replace('\\', '/');
			//pfad = "file://" + pfad + "/MadPics/";
			
			vorIcon = Loader.ladeLokalesBild("buttonvor.gif");
			zurueckIcon = Loader.ladeLokalesBild("buttonzurueck.gif");
			ladenIcon = Loader.ladeLokalesBild("buttonladen.gif");
			stopIcon = Loader.ladeLokalesBild("buttonstop.gif");

		} catch (LoaderException le){
			Fehlermeldung fm = new Fehlermeldung("Die Icons konnten nicht geladen werden.");
			// Bilder konnte nicht geladen werden. Damit die Buttons das auch merken:
			vorIcon=null;   zurueckIcon=null;
			ladenIcon=null; stopIcon=null;
		}

		zurueck_but = new ButtonZurueck(zurueckIcon, this);
		buttonleiste.add(zurueck_but);
		zurueck_but.aktivieren(false);

		vor_but = new ButtonVor(vorIcon, this);
		buttonleiste.add(vor_but);
		vor_but.aktivieren(false);

		laden_but = new ButtonLaden(ladenIcon, this);
		laden_but.aktivieren(true);
		buttonleiste.add(laden_but);

		stop_but = new ButtonStop(stopIcon, this);
		stop_but.aktivieren(false);
		buttonleiste.add(stop_but);

		constraints.gridwidth = 2;
		constraints.weightx = 1.0;	// der Fenstergre anpassen
		constraints.weighty = 0.0;	// der Fenstergre nicht anpassen
		constraints.anchor = GridBagConstraints.NORTHWEST;
		constraints.fill = GridBagConstraints.HORIZONTAL;
		// constraints.gridwidth = GridBagConstraints.RELATIVE;
		gridBag.setConstraints(buttonleiste, constraints);
		add(buttonleiste);

		Panel logocanvas = new Panel();

		logocanvas.setLayout(new FlowLayout(FlowLayout.RIGHT));
		logo = new AnimiertesLogo();

		logocanvas.add(logo);
		constraints.weightx = 0.0;	// der Fenstergre nicht anpassen
		constraints.anchor = GridBagConstraints.NORTHEAST;
		constraints.gridwidth = GridBagConstraints.REMAINDER;
		gridBag.setConstraints(logocanvas, constraints);
		add(logocanvas);

		// URL-Eingabefeld-Leiste

		Label adresse = new Label("Adresse");
		adresse.setAlignment(Label.CENTER);
		// constraints.gridy = 2;
		// constraints.gridheight = 1;
		constraints.gridwidth = 1;
		constraints.anchor = GridBagConstraints.NORTHWEST;
		constraints.fill = GridBagConstraints.NONE;
		constraints.gridwidth = 1;
		gridBag.setConstraints(adresse, constraints);
		add(adresse);

		urlFeld = new TextField(prefs.holeHome());
		//urlFeld.setBackground(Color.gray);
		//urlFeld.setForeground(Color.black);

		// Damit beim Return-Drcken neu geladen wird:
		urlFeld.addKeyListener(new KeyAdapter(){
			public void keyPressed(KeyEvent e){
				if (e.getKeyCode()==KeyEvent.VK_ENTER) load();
		}});

		constraints.gridwidth = GridBagConstraints.REMAINDER;
		constraints.fill = GridBagConstraints.HORIZONTAL;
		gridBag.setConstraints(urlFeld, constraints);
		add(urlFeld);

		// Html-Ebene
		htmlEbene = new BildScrollPane(this);
		//htmlEbene.setBackground(Color.white);
		//htmlEbene.setForeground(Color.gray);
		constraints.weightx = 0.0;	// der Fenstergre nicht anpassen
		constraints.weighty = 1.0;	// der Fenstergre anpassen
		constraints.fill = GridBagConstraints.BOTH;
		constraints.gridwidth = GridBagConstraints.REMAINDER;
		gridBag.setConstraints(htmlEbene, constraints);
		add(htmlEbene);

		// Textzeile zur Ausgabe wichtiger Informationen (was gerade passiert, Fehler,...)
		meldung = new Label("Bereit.");
		//meldung.setBackground(Color.lightGray);
		//meldung.setForeground(Color.black);
		constraints.weighty = 0.0;	// der Fenstergre nicht anpassen
		constraints.gridwidth = GridBagConstraints.REMAINDER;
		gridBag.setConstraints(meldung, constraints);
		add(meldung);

		validate();

	} // Ende des Konstruktors
//------------------------------------------------------------------------
// METHODEN
//------------------------------------------------------------------------
	// Laden starten
	void load() {
		if (runner != null) {
			runner.stop();
			runner = null;
		}
		logo.starten();
		stop.setEnabled(true);
		stop_but.aktivieren(true);
		runner = new Thread(this);
		runner.start();
	}
//------------------------------------------------------------------------
	// Laden anhalten
	void stop_load() {
		statusMeldung("Der Ladevorgang wurde abgebrochen.");
		logo.stoppen();
		stop.setEnabled(false);
		stop_but.aktivieren(false);
		if (runner != null) {
			runner.stop();
			runner = null;
			if (MadScape.TRACE) System.out.println("runner stopped");
		};
	}
//------------------------------------------------------------------------
	// Verlauf vorwrts
	void vor() {
		String urlString = verlauf.naechsteURL();
		urlFeld.setText(urlString);
		// verlauf.testausgabe();
		load ();
	}
//------------------------------------------------------------------------
	// Verlauf zurueck
	void zurueck() {
		// verlauf.testausgabe();
		String neuerOrt = verlauf.letzteURL();
		// spter relative URL vervollstndigen
		urlFeld.setText(neuerOrt);
		load();
	}
//------------------------------------------------------------------------
	// Freigeben oder Sperren der GUI-Komponenten fr "vor"
	void aktiviereVor (boolean enable) {
		vor_but.aktivieren(enable);
		vor.setEnabled(enable);
	}
//------------------------------------------------------------------------
	// Freigeben oder Sperren der GUI-Komponenten fr "vor"
	void aktiviereZurueck (boolean enable) {
		zurueck_but.aktivieren(enable);
		rueck.setEnabled(enable);
	}
//------------------------------------------------------------------------
	// Hilfe aufrufen
	void hilfe() {
		String neuerOrt = prefs.holeHilfe();
		// spter relative URL vervollstndigen
		urlFeld.setText(neuerOrt);
		load();
	}
//------------------------------------------------------------------------
	// Home aufrufen
	void heim() {
		String neuerOrt = prefs.holeHome();
		// spter relative URL vervollstndigen
		urlFeld.setText(neuerOrt);
		load();
	}
//------------------------------------------------------------------------
	// eine Statusmeldung in die Fuzeile eintragen
	void statusMeldung (String info) {
		meldung.setText(info);
	}
//------------------------------------------------------------------------
	// eine neue Formatierte Seite erzeugen
	void formatiereSeite() {
		
		if (MadScape.TRACE) System.out.println("Eine neue FormatierteSeite mit der aktuellen Fensterbreite wird erzeugt");
		
		// Formatierte Seite braucht die echte Breite und Hhe des sichtbaren Bereichs
		// OHNE eventuelle Scrollbars, diese ist nicht ber die html-Ebene zu bekommen (!?)
		// also wird die Viewportsize abgefragt, getestet, ob Scrollbars da sind (ber
		// Grenvergleich) und ggf. die Scrollbarbreite abgezogen
		
		int scrollBreiteH = htmlEbene.getHScrollbarHeight();
		int scrollBreiteV = htmlEbene.getVScrollbarWidth();
		
		int hoehe  = htmlEbene.getViewportSize().height;
		int breite = htmlEbene.getViewportSize().width;
		
		boolean vScroll, hScroll;
		
		if (htmlEbene.bildFlaeche==null) {vScroll=false;hScroll=false;}
		else {
			vScroll=htmlEbene.bildFlaeche.getSize().height > hoehe;
			hScroll=htmlEbene.bildFlaeche.getSize().width > breite;
		}
		if (vScroll) breite += scrollBreiteV;
		if (hScroll) hoehe  += scrollBreiteH;
		
		// FormatierteSeite( ZRSeite, Hhe, Breite, Scrollbarbreite)
		//FormatierteSeite fms = new FormatierteSeite(zrSeite, 300, this.getSize().width, 10);

		FormatierteSeite fms = new FormatierteSeite(zrSeite, hoehe, breite, scrollBreiteV);
		
		// Bild erzeugen, Anker und Links bernehmen
		neuesBild=null;
		neuesBild = fms.erzeugeBild(htmlEbene.bildFlaeche);
		anker = fms.gibAnkerliste();
		links = fms.gibLinkliste();	

		if (MadScape.TRACE) System.out.println("__________________________________________________________");
		if (anker==null) if (MadScape.TRACE) System.out.println("Ankerliste ist Nullpointer.");
		else if (MadScape.TRACE) System.out.println("Anker OK.");
		if (MadScape.TRACE) System.out.println("__________________________________________________________");
		if (MadScape.TRACE) System.out.println("__________________________________________________________");
		if (links==null) if (MadScape.TRACE) System.out.println("Linkliste ist Nullpointer.");
		else if (MadScape.TRACE) System.out.println("Links OK.");
		if (MadScape.TRACE) System.out.println("__________________________________________________________");

		// und Bild anzeigen
		//htmlEbene.setBackground(pg.getbgcolor());
		htmlEbene.zeigeSeite(neuesBild, links, anker);
	}
//------------------------------------------------------------------------
	/**
	 * <i>auch wenn public: Finger weg! </i>
	 */
	public void run() {
		statusMeldung("Eine neue Seite wird geladen...");
		if (MadScape.TRACE) System.out.println("runner started: ");
		if (MadScape.TRACE) System.out.println("brFenster.getSize().width: "+this.getSize().width);
		urlString = urlFeld.getText();
		if (MadScape.TRACE) System.out.println("urlString :"+urlString);

/*//////////// temporr zum lokalen (W95) testen:
//////////// erstes Bild erzeugen und Links vereinbaren

		Image bild = getToolkit().getImage("c:\\madtest.gif");
		MediaTracker mt = new MediaTracker(this);
		mt.addImage(bild, 0);
		try {
			//Warten, bis das Bild vollstndig geladen ist
			mt.waitForAll();
		} catch (InterruptedException e) {
			if (MadScape.TRACE) System.out.println("Bild nicht geladen.");
		}

		// Daten fr mein Testbild
		links = new LinkMenge();
		links.fuegeAn(new LinkBereich("#oben", 240,180,315,35));
		links.fuegeAn(new LinkBereich("#mitte", 142,415,527,69));
		links.fuegeAn(new LinkBereich("http://www.MadScape.com", 211,685,398,31));

		anker = new AnkerMenge();
		anker.fuegeAn(new Anker("#oben",180));
		anker.fuegeAn(new Anker("#mitte",415));
		//anker.fuegeAn(new Anker("#unten",685));
		htmlEbene.zeigeSeite(bild, links, anker, this);
	 	// neue Seite in Verlauf eintragen
		verlauf.neueURL(urlFeld.getText());
		// fertig.
		logo.stoppen();
		stop.setEnabled(false);
		stop_but.aktivieren(false);
		statusMeldung("Bereit.");
		verlauf.testausgabe();
*/
////////////////////////////////////////////
///// UNI-Variante


			try {
 				if (MadScape.TRACE) System.out.println("__________________________________________________________");
	 			if (MadScape.TRACE) System.out.println("BrowserFenster ld neue Seite");
	 			if (MadScape.TRACE) System.out.println("__________________________________________________________");

	 			// Parser erzeugt Page
 				ips=null;
 				ips = Loader.ladeHTML(urlString);
 				pars=null;
 				pars = new Parser(ips);
 				pg=null;
 				pg = pars.page();

 				// Zwischenreprsentation
 				zrSeite = null;
 				zrSeite = new ZRSeite(pg, urlString, prefs);

	 			// Formatierte Seite
				formatiereSeite();

 				if (MadScape.TRACE) System.out.println("__________________________________________________________");
	 			if (MadScape.TRACE) System.out.println("BrowserFenster: neue Seite wurde komplett geladen");
	 			if (MadScape.TRACE) System.out.println("__________________________________________________________");

	 			// neue Seite in Verlauf eintragen
				verlauf.neueURL(urlFeld.getText());

				// fertig.
				this.setTitle("MadScape: " + zrSeite.gibtitel());
				stop.setEnabled(false);
				logo.stoppen();
				stop_but.aktivieren(false);
				statusMeldung("Bereit.");

				verlauf.testausgabe();

		 	} catch (MalformedURLException mue) {
	 			Fehlermeldung fm = new Fehlermeldung("URL nicht korrekt: "+mue.getMessage());
	 			stop_load();
	 		} catch (ParseException pe) {
	 			Fehlermeldung fm = new Fehlermeldung("ParserException: "+pe.getMessage());
	 			stop_load();
		 	} catch (IOException ioe){
		 		Fehlermeldung fm = new Fehlermeldung("IOFehler (Stream fr Parser): "+ioe.getMessage());
		 		stop_load();
			}
	}	// Ende run
//------------------------------------------------------------------------
}