
package MadScape.GUI;

import java.awt.*;
import MadScape.GUI.*;
import MadScape.FormatierteSeite.*;

/**
 * Die ScrollPane stellt den Bereich fr die Anzeige der HTML-Seite
 * (als Bild) zur Verfgung.
 * @author Andr Vratislavsky
 * @author Max Haustein
 */
public class BildScrollPane extends java.awt.ScrollPane {
	
	// Canvas fr die Anzeige des Bildes
	BildCanvas bildFlaeche;
//------------------------------------------------------------------------
	/**
	 * Eine neue Bildflche erzeugen. Scrollbars werden aktiviert, 
	 * falls das Bild grer als der aktuelle Bereich ist.

	 * @param br das BrowserFenster, in dem wir uns befinden, ntig, damit
	 *           links geladen werden knnen usw.
	 */
	public BildScrollPane (BrowserFenster br) {
		super(ScrollPane.SCROLLBARS_AS_NEEDED);
		//super(ScrollPane.SCROLLBARS_ALWAYS);
		
		// vorerst leere BildCanvas ohne Bild hinzufgen
		bildFlaeche = new BildCanvas(null, null, null, this, br);
		//bildFlaeche.setSize(20,20);
		this.add(bildFlaeche);
	}
//------------------------------------------------------------------------
	/**
	 * Zeige das Bild einer neuen Seite an.

	 * @param bild das Bild der HTML-Seite
	 * @param lm die Links der Seite
	 * @param am die Anker auf der Seite
	 
	 * @see MadScape.GUI.BildCanvas
	 */
	public void zeigeSeite (Image bild, LinkMenge lm, AnkerMenge am) {
		//remove(bildFlaeche);
		//bildFlaeche = new BildCanvas (bild, lm, am, this, br);
		//add(bildFlaeche);
		bildFlaeche.zeigeNeuesBild(bild, lm, am);
		setzePosition(0);
		validate();
		repaint();
	}
//------------------------------------------------------------------------
	/**
	 * setzt die Scroll-Position (in vertikaler Richtung) an die 
	 * bergebene Stelle. Die horizontale Scrollposition bleibt erhalten.
	 * @param y die gewnschte Scrollposition (0 ist oben)
	 */
	public void setzePosition (int y) {
		Point p = getScrollPosition();
		p.y = y;
		setScrollPosition(p);
	}
}