
package MadScape.GUI;

import java.awt.*;
import java.awt.event.*;
import java.net.*;

import MadScape.MadScape;
import MadScape.FormatierteSeite.*;

/**
 * Ein Canvas fr die Anzeige eines Bildes.
 * @author Andr Vratislavsky
 * @author Max Haustein
 */
public class BildCanvas extends java.awt.Canvas {
	// Das angezeigte Bild:
	Image bild;
	// Alle Links der Seite (Cursor verndern, anspringen)
	LinkMenge links;
	// Alle anspringbaren Anker auf der Seite
	AnkerMenge anker;
	// Die ScrollPane, in der wir uns befinden (Scrollposition setzen)
	BildScrollPane bsp;
	// Das Browser-Fenster, in dem sich das Canvas befindet
	// ntig um beim Anwhlen eines Links das Laden einer neuen Seite
	// auslsen zu knnen:
	BrowserFenster bf; 
//------------------------------------------------------------------------
	/**
	 * erzeugen eine einfache Bildflaeche ohne Links usw.
	 */
	public BildCanvas (Image b) {
		bild = b;
		// Gre dem Bild anpassen:
		if (bild!=null) setSize(b.getWidth(this),b.getHeight(this));
	}
//------------------------------------------------------------------------
	/**
	 * Erzeugt eine neue Bildflche.
	 * Erhlt das Bild und alles, was fr die Funktionalitt der Links
	 * notwendig ist (darunter die BildScrollPane um die Scrollposition
	 * innerhalb der Seite setzen zu knnen und das BrowserFenster um
	 * um das Laden einer neuen Seite auslsen zu knnen
	 *
	 * @param b das Bild der HTML-Seite
	 * @param l die Links der Seite
	 * @param a die Anker auf der Seite
	 * @param p die ScrollPane in der wir uns befinden
	 * @param br das BrowserFenster, in dem wir uns befinden
	 */
	public BildCanvas (Image b, LinkMenge l, AnkerMenge a, 
	                   BildScrollPane p, BrowserFenster br) {
		// Referezen bernehmen:
		bild = b;
		links = l;
		anker = a;
		bsp = p;
		bf = br;
		
		setBackground(Color.white);
		
		// Gre dem Bild anpassen:
		if (bild!=null) setSize(b.getWidth(this),b.getHeight(this));
		//if (MadScape.TRACE) System.out.println("groesse bernommen: width="+b.getWidth(this)+", heigth="+b.getHeight(this));
		// ---------------------------------------------------------------
		// Cursor ndern, falls Link berhrt:
		addMouseMotionListener(new MouseMotionAdapter() {
			
			Cursor hand = new Cursor(Cursor.HAND_CURSOR),
			       standard = new Cursor(Cursor.DEFAULT_CURSOR);
			
			public void mouseMoved(MouseEvent e){
				if (links!=null)
					if (links.istLink(e.getX(),e.getY())) setCursor(hand);
					else setCursor(standard);
			}
		});
		// ---------------------------------------------------------------
		// Funktionalitt der Links
		addMouseListener(new MouseAdapter() {
			
			int x,y;
			String ort;
			
			public void mouseReleased(MouseEvent e){
				x=e.getX(); y=e.getY();
				if (links!=null && links.istLink (x,y)) {
					ort = links.holeLink (x,y);
					if (MadScape.TRACE) System.out.println("ort aus links: "+ort);
					if (ort!=null) {					
						if (ort.charAt(0)=='#') {
							// Falls nur ein Anker angesprungen werden soll ->
							// Scroll-Position setzen:
							try {
								if (MadScape.TRACE) System.out.println("gesuchter ort:"+ort.substring(1));
								int scrollpos = anker.woIst(ort.substring(1));
								if (MadScape.TRACE) System.out.println("scrollpos"+scrollpos);
								bsp.setzePosition(scrollpos);
							} catch (KeinAnkerException kaex){
								if (MadScape.TRACE) System.out.println("AnkerEx"+kaex.getMessage());
								//// und nochmal mit # als prfix
								try {
									int scrollpos = anker.woIst(ort);
									bsp.setzePosition(scrollpos);
									
								} catch (KeinAnkerException kaex2){
									Fehlermeldung fm2 = new Fehlermeldung ("Kein Anker <"+ort+"> auf dieser Seite.");
								}
							}
						} else {
							// sonst URL-Syntax prfen, ggf. relativen
							// Link vervollstndigen und das BrowserFenster
							// veranlassen, die neue Seite zu laden
							
							// alt:
							//bf.urlFeld.setText(ort);
							//bf.load ();
							URL temp=null;
							try {
								temp = new URL (ort);
								// falls "ort" eine relative URL war,
								// geht das schief, also im catch-Teil vervollstndigen, sonst laden
								
								bf.urlFeld.setText(ort);
								bf.load ();
								
							} catch (MalformedURLException mux) {
								try {
									// Seitenbasis holen,
									URL base = new URL (bf.urlString);
									// relativ ergnzen
									temp = new URL (base, ort);
									// und laden lassen
									bf.urlFeld.setText(temp.toString());
									bf.load();
								} catch (MalformedURLException mux2) {
									// hier haben wir ein Problem und geben auf...
								}
							}
						} // fi (anker oder link)
					} // fi (ort!=null)
				}  // fi links vorhanden
			}
		});
		// ---------------------------------------------------------------
	}
//------------------------------------------------------------------------
	/**
	 * Zeigt ein neus Bild (einer neuen HTML-Seite) an.
	 * Erhlt das Bild und alles, was fr die Funktionalitt der Links
	 * notwendig ist.
	 *
	 * @param b das Bild der HTML-Seite
	 * @param l die Links der Seite
	 * @param a die Anker auf der Seite
	 */
	public void zeigeNeuesBild (Image b, LinkMenge l, AnkerMenge a) {
		// Referezen bernehmen:
		bild = null;  bild = b;
		links = null; links = l;
		anker = null; anker = a;
		
		// Gre dem Bild anpassen:
		if (bild!=null) setSize(b.getWidth(this),b.getHeight(this));
		if (MadScape.TRACE) System.out.println("BildCanvas: Groesse uebernommen: width="+b.getWidth(this)+", heigth="+b.getHeight(this));
		validate();
		repaint();
	}
//------------------------------------------------------------------------
	/**
	 * das Bild ins Canvas zeichnen
	 * @param g java.awt.Graphics
	 */
	public void paint (Graphics g) {
		if (bild!=null) g.drawImage(bild,0,0,this);
	}
//------------------------------------------------------------------------
}