
package MadScape.GUI;

import java.awt.*;
import java.awt.event.*;
import MadScape.GUI.*;
import MadScape.FormatierteSeite.*;

/**
 * Ein Button der ein Icon trgt (Text ggf. im Bild)
 * Bildformat: 4 Bilder in einer Datei nebeneinander:
 * normale, mouseover, gedrckt, disabled
 * @author Andr Vratislavsky
 * @author Max Haustein
 */
public class BildButton extends java.awt.Canvas {
	
	Image bild;
	boolean aktiv=true;
	
	int bildnr=0;
	int bildgr=40;
	
	// Das Browser-Fenster, in dem sich der Button befindet
	// ntig um Aktionen auslsen zu knnen
	BrowserFenster bf;
	
	// Was, wenn kein Bild da?
	boolean bildDa; // haben wir ein Bild oder einen null-Pointer?
	String ersatz;
	Font font;
	int stringBreite, stringHoehe;
	
//------------------------------------------------------------------------
	/**
	 * Einen Bildbutton erzeugen.
	 * @param icon das Bild fr den Button
	 * @param browser das BrowserFenster, in dem sich der Button befinden wird
	 * @param ersatzText falls das Bild ein null-Pointer ist
	 */
	public BildButton (Image icon, BrowserFenster browser, String ersatzText) {
		bild = icon;
		bf = browser;
		ersatz = ersatzText;
		bildDa = bild!=null;
			
		// Entweder auf Bild oder Ersatztext vorbereiten
		if (bildDa) {
			setSize(bild.getWidth(this)/4,bild.getHeight(this));
			bildgr = bild.getWidth(this)/4;
		} else {
			setSize(40,40);
			// Ersatztext abmessen:
			font = new Font ("Arial",Font.BOLD,10);
			FontMetrics fm = getFontMetrics(font);
			stringBreite = fm.stringWidth(ersatz);
			stringHoehe = fm.getAscent()/2;
		}
		
		addMouseListener(new MouseAdapter() {

			//------------------------------------------------------------
			public void mouseEntered(MouseEvent e){
				if (aktiv) bildnr=1;
				repaint();
			}
			//------------------------------------------------------------
			public void mouseExited(MouseEvent e){
				if (aktiv) bildnr=0;
				repaint();
			}
			//------------------------------------------------------------
			public void mouseReleased(MouseEvent e){
				if (aktiv) bildnr=1;
				repaint();
				if (aktiv) funktion();
			}
			//------------------------------------------------------------
			public void mousePressed(MouseEvent e){
				if (aktiv) bildnr=2;
				repaint();
			}
		});
		// ---------------------------------------------------------------
	}
//------------------------------------------------------------------------
/**
 * Soll der Button anklickbar sein?
 */
public void aktivieren (boolean akt) {
	if (!akt) bildnr = 3;
	else bildnr = 0;
	aktiv = akt;
	repaint();
}
//------------------------------------------------------------------------
/**
 * was soll passieren, wenn der Button angeklickt wird?
 * Sollte dann in erbenden Klassen berschrieben werden
 */
void funktion(){}
//------------------------------------------------------------------------
	/**
	 * wird vom AWT aufgerufen
	 */
	public void paint (Graphics g) {
		if (bildDa) 
			CTool.PicBlt(g, 0, 0, getSize().width, getSize().height, bild, bildnr*bildgr,0, this);
		else {
			g.setColor(Color.darkGray);
			g.fillRect(0,0,40,40);
			g.setFont(font);
			g.setColor(Color.lightGray);
			g.drawString(ersatz, (40-stringBreite)/2 , 20+stringHoehe);
		}
	}
//------------------------------------------------------------------------
	/**
	 * wird intern aufgerufen
	 */
	public void update(Graphics g)	{
		paint(g);
	}
//------------------------------------------------------------------------
}