
package MadScape.GUI;

import java.awt.*;
import MadScape.*;
import java.net.*;

/**
 * Ein Canvas, das ein animiertes Logo darstellt. Die Animation kann 
 * gestartet und gestoppt werden. Das Bild wird intern geladen.
 */
public class AnimiertesLogo extends java.awt.Canvas implements Runnable {

	MediaTracker Tracker;
	Thread Timer;
	int CurrX, CurrY;
	Dimension PicDim;
	Point DrawPos;
	Image BuffImg;
	boolean running=false;
	boolean bildDa=false; // konnte die Animation geladen werden?
//------------------------------------------------------------------------
// KONSTRUKTOR
//------------------------------------------------------------------------
	/**
	 * erzeugt ein neues Canvas mit Animation. Die Animation wird noch
	 * nicht gestartet.
	 */
	public AnimiertesLogo(){
		/*// LOKAL
		BuffImg=Toolkit.getDefaultToolkit().getImage("C:\\DancingM_Table_64.gif");
		
		Tracker=new MediaTracker(this);
		Tracker.addImage(BuffImg,0);
		try{Tracker.waitForID(0);}
		catch(InterruptedException e){return;}
		bildDa=true;
		*/
		
		// UNI:
		BuffImg=null;
		try {
			//String pfad = System.getProperty("user.dir");
			// unter W95 wird der Pfad leider mit \ geliefert.
			// in der Hoffnung, da kein UNIX-Verzeichnis "\" enthlt:
			//pfad = pfad.replace('\\', '/');
			BuffImg = Loader.ladeLokalesBild("animation.gif");
			
			bildDa=true;
		} catch (LoaderException le){
			Fehlermeldung fm = new Fehlermeldung ("Die Animation fr den Ladevorgang konnte nicht geladen werden.");
		}
		
		PicDim=new Dimension(40,40);
		DrawPos=new Point(1,1);
		setSize(42,42);
		
		Timer=new Thread(this);		
		if (bildDa) Timer.start();
	}

//------------------------------------------------------------------------
// Methoden
//------------------------------------------------------------------------
	/**
	 * Die Animation wird bis auf Widerruf gestartet.
	 */
	public void starten() {
		running = true;
		Timer=new Thread(this);    // auch falls kein Bild da (sonst nullPointerException)
		if (bildDa) Timer.start();
	}
//------------------------------------------------------------------------	
	/**
	 * Die Animation wird gestoppt. Es wird wieder das erste Bild gezeigt.
	 */
	public void stoppen() {
		running=false;
		Timer.stop();
		repaint();
	}
//------------------------------------------------------------------------	
	/**
	 * <i>auch wenn public: Finger weg!</i>
	 */
	public void stop() {
		Timer.stop();
	}
//------------------------------------------------------------------------	
	/**
	 * <i>auch wenn public: Finger weg!</i>
	 */
	public void run() {
		if (bildDa)
		while (true) {
			try{Thread.currentThread().sleep(100);}
			catch(InterruptedException e){}
			repaint();
		}
	}
//------------------------------------------------------------------------	
	/**
	 * <i>auch wenn public: Finger weg!</i>
	 */
	public void update(Graphics g) {
		if (bildDa) {
			if (running) {
				CTool.PicBlt(g,DrawPos.x,DrawPos.y,PicDim.width,PicDim.height,BuffImg,CurrX,CurrY,this);
				CurrX+=PicDim.width;
				if(CurrX>=10*PicDim.width){
					CurrX=0;
					CurrY+=PicDim.height;
					if(CurrY>=10*PicDim.height) CurrY=0;
				}
			} else {
				CTool.PicBlt(g,DrawPos.x,DrawPos.y,PicDim.width,PicDim.height,BuffImg,0,0,this);
			}
		}
	}
//------------------------------------------------------------------------
	/**
	 * <i>auch wenn public: Finger weg!</i>
	 */
	public void paint(Graphics g) {
		if (bildDa) {
			g.setColor(Color.gray);
			g.draw3DRect(DrawPos.x-1,DrawPos.y-1,PicDim.width+1,PicDim.height+1,true);
			CTool.PicBlt(g,DrawPos.x,DrawPos.y,PicDim.width,PicDim.height,BuffImg,CurrX,CurrY,this);
		}
	}
//------------------------------------------------------------------------	
}