package MadScape.FormatierteSeite;
import MadScape.Zwischenrepraesentation.*;
import java.awt.*;

/** Die Klasse ZeilenElement beinhaltet ein Element der
 *   Zeile, was entweder ein Wort, ein Bild, oder ein
 *   Leerzeichen ist. 
 *   @author Alexander L&uuml;ning
 *   @author Alexander Knabner
 *	 @author Thomas Sundermann
 */
public abstract class ZeilenElement {

  /** Position des Elementes auf der Seite, y ist Grundlinie */
  public int x,y;

  /** Ausdehnung des Elements*/
  public int breite,hoehe;

  /** Abst&auml;nde zur Grundlinie */
  int ueberhoehe,unterhoehe;

  /** Der Konstruktor */
  public ZeilenElement() { 
    super();
    breite = hoehe = x = y = ueberhoehe = unterhoehe = 0; 
  }
 
  /** Methode, gibt die &Uuml;berh&ouml;he des Zeilenelements zur&uuml;ck*/
  public int gibUeberhoehe() {
    return ueberhoehe; 
  }
  
  /** Methode, gibt die Unterh&ouml;he des Zeilenelements zur&uuml;ck*/ 
  public int gibUnterhoehe() {
    return unterhoehe;
  }
  
  /** Methode, gibt die Breite des Zeilenelements zur&uuml;ck*/  
  public int gibBreite() {
    return breite;
  }
 
  /** Methode, gibt die H&ouml;he des Zeilenelements zur&uuml;ck*/
  public int gibHoehe() {
     return hoehe;
  }
              
  /** gibt die X-Koordinate des Zeilenelements zurck*/ 
  public int gibX() {
    return x;	
  }
              
  /** gibt die Y-Koordinate des Zeilenelements zurck*/ 
  public int gibY() {
    return y;	
  }

  /** setzt die X-Koordinate des Zeilenelements*/ 
  public void setzeX(int xneu) {
    this.x=xneu;	
  }
  
  /** setzt die Y-Koordinate des Zeilenelements*/ 
  public void setzeY(int yneu) {
    this.y=yneu;	
  }

  /** Methode die die Attribute des Zeilenelements liefert */
  public abstract Attribute gibAttribute();

  /** Methode, die das Zeilenelement in ein gegebenes Grafik-Objekt zeichnet */
  public abstract void zeichneDich(Graphics g, LinkMenge link, AnkerMenge anker);
  
}
  
  