package MadScape.FormatierteSeite;

import MadScape.Zwischenrepraesentation.*;
import java.lang.*;
import java.awt.*;
import java.util.*;

/** Diese Klasse stellt einen Block an Woertern, Bildern etc. dar, der sich
  * ueber eine Zeile und die gesamte Breite des Eingabefensters erstreckt.
  * Die Klasse ist abstrakt.
  * @author Andre Baradari
  */
public abstract class ZeilenBlock{
	protected int einrueckung=0, hoehe=0, x=0, y=0;

	protected int breite=0;			// Breite des Zeilenblockes, hngt vom Typ und vom Inhalt ab

/** Liefert die Breite des Zeilenblockes,
  * das fertige Bild ist so breit, wie der breiteste Zeilenblock.
  */
	public abstract int gibBreite();

/** Liefert die Hoehe des Zeilenblockes.
  */
	public abstract int gibHoehe();

/** Traegt ein Zwischenelement ein, falls es reinpasst.
  * @param element einzufuegendes Zwischenelement.
  * @returns Gibt an, ob das Zwischenelement in den Zeilenblock passt,
  * ohne die Breite des Ausgabefensters zu sprengen.
  */
	public abstract boolean fuegeAn( ZwischenElement element);

/** Traegt eine Liste von Zwischenelementen ein, falls sie reinpasst.
  * @param liste Liste der einzufuegenden Zwischenelemente.
  * @returns Gibt an, ob die Liste von Zwischenelementen in den Zeilenblock passt,
  * ohne die Breite des Ausgabefensters zu sprengen.
  */
	public abstract boolean fuegeAn( Vector liste);

/** Beendet das Einfgen in die Liste und berechnet smtliche Ausmae,
 *  die spter von zeichneDich gebraucht werden.
 */
	public abstract void schliesse();

/** Initiiert das Zeichnen des Zeilenblocks, mu von allen erbenden
  * Klassen implementiert werden.
  */
	public abstract void zeichneDich(Graphics graphics, LinkMenge links, AnkerMenge anker);
}