package MadScape.FormatierteSeite;

import java.awt.*;
import java.util.*;

import MadScape.Zwischenrepraesentation.*;



/** Eine Zeile ist eine horizontale Anordnung von Worten und Bildern
  * (wer htte das gedacht). Die Ausrichtung erfolgt an der Grundlinie
  * des Textes.
  * @author Alexander Knabner
  * @author Alexander L&uuml;ning
  * @author Thomas Sundermann
  * @see TextZeile
  * @see Linie
  */
public abstract class Zeile extends ZeilenBlock {



	//  Variablen

	/** Ausdehnung ber und unter der Grundlinie (berechnet aus den
	  * Attributen der Zeilenelemente).
	  * @see ZeilenElement
	  */
	protected int ueberhoehe, unterhoehe;

	/** Bei einer Liste gibt diese Variable das bei einem neuen
	  * Listenpunkt zu zeichnende Symbol an
	  */
	protected char symbol;



	//  Constructor

	/** Ist nicht zu atemberaubend denke ich ; )
	  */
	public Zeile() { super(); ueberhoehe = unterhoehe = 0; }
//  public Zeile( int y ) { super(); ueberhoehe = unterhoehe = 0; }
//  public Zeile( Vector v, int y ) { super(); ueberhoehe = unterhoehe = 0; }
//  public Zeile( ZwischenElement element, int y ) { super(); ueberhoehe = unterhoehe = 0; }



	//  Methoden

	/** &Uuml;bergibt die Breite der Zeile,
	  */
	public abstract int gibBreite();

	/** &Uuml;bergibt die H&ouml;he der Zeile.
	  */
	public abstract int gibHoehe();

	/** Tr&auml;gt ein Zwischenelement von der Zwischenstruktur in die Zeile ein,
	  * falls es reinpa&szlig;t.
	  * @param element einzuf&uuml;gendes Zwischenelement.
	  * @return Gibt an, ob das Zwischenelement in den Zeilenblock pa&szlig;t,
	  * ohne die Breite des Ausgabefensters zu sprengen.
	  * @see MadScape.Zwischenrepraesentation.Zwischenelement
	  */
	public abstract boolean fuegeAn( ZwischenElement element);

	/** Tr&auml;gt eine Liste von Zwischenelementen ein, falls sie reinpa&szlig;t.
	  * @param liste Liste der einzuf&uuml;genden Zwischenelemente.
	  * @return Gibt an, ob die Liste von Zwischenelementen in den Zeilenblock pa&szlig;t,
	  * ohne die Breite des Ausgabefensters zu sprengen.
	  */
	public abstract boolean fuegeAn( Vector liste);

	/** Wird aufgerufen, wenn die Zeile 'voll' ist. Alle relevanten Variablen werden
	  * aktualisiert (Position, Ausdehnung etc. sowohl von der Zeile, als auch den
	  * ZeilenElementen
	  */
	public abstract void schliesse();

	/** Initiiert das Zeichnen der Zeile.
	  * @param graphics ist das Graphics Object, auf dem gezeichnet werden soll.
	  */
	public abstract void zeichneDich(Graphics graphics, LinkMenge links, AnkerMenge anker);
}
