package MadScape.FormatierteSeite;
import MadScape.Zwischenrepraesentation.*;
import java.awt.*;

/** Klasse f&uuml;r die Darstellung von Worten in der formatierten
 *   Seite. 
 *	 @author Alexander L&uuml;ning
 *   @author Alexander Knabner
 *	 @author Thomas Sundermann
 */
public class Wort extends ZeilenElement {

  /** attribute enth&auml;lt die Attribute des Wortes	*/
	public Attribute attribute;
  
	/** text enth&auml;lt den Text des Wortes*/
	public String text;
  
	private Color farbe;
  private Font schrift;
  private FontMetrics schriftwerte;
  
  /**Konstruktor zum Erzeugen eines Wort-Objektes
  * @param zelement Da&szlig; zu verarbeitende Zwischenelement
	* @param x Die X-Position in der Zeile
	*/
  public Wort(MadScape.Zwischenrepraesentation.Wort zelement, int x){
		super();
    this.text=zelement.gibtext();
    this.attribute=zelement.gibattribut();
		this.x = x;
    schrift = attribute.gibschrift();
		Toolkit tk = Toolkit.getDefaultToolkit();
    schriftwerte = tk.getFontMetrics( schrift);
    ueberhoehe = schriftwerte.getMaxAscent();
    unterhoehe = schriftwerte.getMaxDescent();
    breite = schriftwerte.stringWidth(text);
    hoehe = ueberhoehe+unterhoehe;
    farbe = attribute.gibfarbe();
    if (MadScape.MadScape.TRACE) { 
      System.out.print("Wort.Wort(): Ich bin ein Wort");
      System.out.print("  X-Pos: ");System.out.print(x);
      System.out.print("  Y-Pos: ");System.out.print(y);
      System.out.print("  Breite: ");System.out.print(breite);
      System.out.print("  Hhe: ");System.out.print(hoehe);
      System.out.print("  Text: ");System.out.println(text);
   }
  }

  /** Methode, die die Attribute des Wortes zur&uuml;ckgibt*/
  public Attribute gibAttribute(){
		return attribute;
	}
  
  /** Methode,die das Wort auf dem Bildschirm darstellt
  *  @param g ein Graphics-Objekt in das gezeichnet wird
  */
  public void zeichneDich(Graphics g, LinkMenge link, AnkerMenge anker){
    g.setColor(farbe);
    g.setFont(schrift);
    g.drawString(text, x, y);
    if (attribute.istunterstrichen()) g.drawLine(x,(y+1),(x+breite),(y+1));
    if (MadScape.MadScape.TRACE) { 
			System.out.println("Wort.zeichneDich: Wort gezeichnet");
		}
    if (attribute.istverweis()) {
      if (MadScape.MadScape.TRACE) { 
        System.out.println("Wort.zeichneDich: Wort in Linkmenge");
      }
      link.fuegeAn(new LinkBereich(attribute.gibverweistext(), x, (y-ueberhoehe), breite, hoehe));
    }
    if (attribute.istanker()) {
      if (MadScape.MadScape.TRACE) { 
        System.out.println("Wort.zeichneDich: Wort in Ankermenge");
      }
      anker.fuegeAn(new Anker(attribute.gibverweistext(), (y-ueberhoehe)));
    }
  }
}
