package MadScape.FormatierteSeite;

import java.awt.*;
import java.util.*;

import MadScape.Zwischenrepraesentation.*;

public class UmlaufBild extends ZeilenBlock{
  private int ausrichtung;
  private Attribute attribute;		// Attributobjekt
  private Image image;
  private Vector zeilen;          // Zeilen neben dem Umlaufbild
  private TextZeile firstLine;
  private int fensterbreite;
  private int bildbreite, bildhoehe;
  private MadScape.Zwischenrepraesentation.Bild bildelement;
  private int startY;
  private BildObserver dummy = new BildObserver();

  /**
   * Default-Constructor
   */
  public UmlaufBild() { super(); }

  /**
   * Standard-Constructor
   */
  public UmlaufBild(MadScape.Zwischenrepraesentation.Bild bildelement , int akthoehe , int fensterbreite) {
    super();
    this.fensterbreite = fensterbreite;
    this.bildelement   = bildelement;
    image              = bildelement.gibbild();
    ausrichtung        = bildelement.gibausrichtung();
    attribute          = bildelement.gibattribute();
    zeilen             = new Vector();  // Vector mit allen Zeilen, die neben das Bild sollen
    if (bildelement.gibistprozent()) {
      bildbreite       = image.getWidth(dummy) * bildelement.gibbreite()/100+4;
      bildhoehe        = image.getHeight(dummy) * bildelement.gibhoehe()/100+4;
    } else {
      bildbreite       = bildelement.gibbreite()+4;
      bildhoehe        = bildelement.gibhoehe()+4;
    }    
    startY             = akthoehe;
    y                  = akthoehe;
    hoehe              = 0;    // Die Summe der Hhen aller Zeilen neben dem Umlaufbild
    if (ausrichtung==MadScape.Zwischenrepraesentation.ZwischenElement.LINKS) x += bildbreite;
    firstLine          = new TextZeile(x,y,(fensterbreite-bildbreite));  // Die erste Zeile neben dem Bild
    zeilen.addElement(firstLine); // Vektor mit allen Zeilen wird mit der ersten initiiert
  }

  public int gibBreite() {
    return breite;
  }

  /**
   * &Uuml;bergibt die H&ouml;he der Zeile.
   */
  public int gibHoehe(){
    return hoehe;
  }

  /**
   * Tr&auml;gt ein Zwischenelement von der Zwischenstruktur in die Zeile ein,
   * falls es reinpa&szlig;t.
   * @param element einzuf&uuml;gendes Zwischenelement.
   * @return Gibt an, ob das Zwischenelement in den Zeilenblock pa&szlig;t,
   * ohne die Breite des Ausgabefensters zu sprengen.
   * @see MadScape.Zwischenrepraesentation.Zwischenelement
   */
  public boolean fuegeAn(ZwischenElement element) {
    if (hoehe < bildhoehe) {
      Zeile lastLine = (Zeile) zeilen.lastElement();
      if (element.gibTyp() == ZwischenElement.HLINIE) {
	lastLine.schliesse();
	hoehe += lastLine.gibHoehe();
	y += lastLine.gibHoehe();
	if (hoehe < bildhoehe) {
	  Linie linie = new Linie(x,y,(fensterbreite-bildbreite));
	  zeilen.addElement(linie);
	  hoehe += linie.gibHoehe();
	  y += lastLine.gibHoehe();
	} else {
	  TextZeile neuZeile = new TextZeile(x,y,(fensterbreite-bildbreite));
	  zeilen.addElement(neuZeile);
	  return false;
	}
      } else if (!lastLine.fuegeAn(element)) {
	  lastLine.schliesse();
	  hoehe += lastLine.gibHoehe();
	  y += lastLine.gibHoehe();
	  TextZeile neuZeile = new TextZeile(x,y,(fensterbreite-bildbreite));
	  zeilen.addElement(neuZeile);
	  this.fuegeAn(element);
      }
      return true;
    } else return false;
  }
  
  
  /**
   * Tr&auml;gt eine Liste von Zwischenelementen ein, falls sie reinpa&szlig;t.
   * @param liste Liste der einzuf&uuml;genden Zwischenelemente.
   * @return Gibt an, ob die Liste von Zwischenelementen in den Zeilenblock pa&szlig;t,
   * ohne die Breite des Ausgabefensters zu sprengen.
   */
  public boolean fuegeAn(Vector liste) {
    if (hoehe < bildhoehe) {
      Zeile lastLine = (Zeile) zeilen.lastElement();
      if (!lastLine.fuegeAn(liste)) {
	lastLine.schliesse();
	hoehe += lastLine.gibHoehe();
	y += lastLine.gibHoehe();
	TextZeile neuZeile = new TextZeile(x,y,(fensterbreite-bildbreite));
	zeilen.addElement(neuZeile);
	this.fuegeAn(liste);
      }
      return true;
    } else return false;
  }
  
  /**
   * Wird aufgerufen, wenn die Zeile 'voll' ist. Alle relevanten Variablen werden
   * aktualisiert (Position, Ausdehnung etc. sowohl von der Zeile, als auch den
   * ZeilenElementen
   */
  public void schliesse() {
    Zeile lastLine = (Zeile) zeilen.lastElement();
    lastLine.schliesse();
    hoehe += lastLine.gibHoehe();
    y += lastLine.gibHoehe();
    int maxBreit=0;
    for (int i=0; i<zeilen.size()-1;i++) {
      Zeile aktZeile = (Zeile) zeilen.lastElement();
      if (maxBreit < aktZeile.gibBreite()) maxBreit=aktZeile.gibBreite();
    }
    breite = maxBreit + bildbreite;
    if (hoehe < bildhoehe) hoehe=bildhoehe;
  }

  /**
   * Initiiert das Zeichnen des UmlaufBildes samt Zeilen daneben.
   * @param graphics ist das Graphics Object, auf dem gezeichnet werden soll.
   */
  public void zeichneDich(Graphics graphics, LinkMenge links, AnkerMenge anker) {
    Bild bild;
    if (ausrichtung==MadScape.Zwischenrepraesentation.ZwischenElement.LINKS){
      bild = new Bild(bildelement,x-bildbreite+2);
    } else {
      bild = new Bild(bildelement, (fensterbreite-bildbreite+2));
    }
    bild.setzeY(startY + bildhoehe-2);
    bild.zeichneDich(graphics,links,anker);
    for (int i=0; i<zeilen.size(); i++){
      Zeile zeile = (Zeile) zeilen.elementAt(i);
      zeile.zeichneDich(graphics,links,anker);
    }
  }
}






