 package MadScape.FormatierteSeite;

import java.awt.*;
import java.util.*;

import MadScape.Zwischenrepraesentation.*;

/** Das ist die eigentliche Wort-Bild-Zeile. Die ganzen interessanten
  * Attribute erbt sie von Zeile und Zeilenblock...
  * @author Alexander Knabner
  * @author Alexander L&uuml;ning
  * @author Thomas Sundermann
  */
public class TextZeile extends Zeile {

	//  Variablen

	/** Beinhaltet die einzelnen Elemente der Zeile.
	  * @see ZeilenElement
	  */
	protected Vector zeilenelemente;
	
	//  Anzahl der Pixel um die Listen einzurcken sind
	private static final int listspace = 50;
	// Textattribute
	private static final int LEFT = 0;
	private static final int CENTER = 1;
	private static final int RIGHT = 2;
	// Listentypen
	private static final char SQUARE = 's';
	private static final char CIRCLE = 'c';
	private static final char DISC = 'd';
	//  Breite des Fensters
	private int fensterbreite;
	// Bei Formatierungen mu zustzlich eingerckt werden
	private int istformat = LEFT;	// 0 - links, 1 - Mitte, 2 - rechts



	// constructors

	/** Initialisieren des Vectors etc.
	  */
	public TextZeile() {
		super();
		zeilenelemente = new Vector();
		if (MadScape.MadScape.TRACE) System.out.println("new TextZeile()");
		if (MadScape.MadScape.TRACE) System.out.println("  sollte eigentlich nicht auftauchen...");
	}
	/** &Uuml;bergeben wird die y-Position der neuen Zeile.
	  */
	public TextZeile( int y , int fensterbreite ) {
		super();
		zeilenelemente = new Vector();
		this.y = y;
		this.fensterbreite = fensterbreite;
		if (MadScape.MadScape.TRACE) {
			System.out.println("new TextZeile(y,fensterbreite)");
			System.out.print("  y             : "); System.out.println(this.y);
			System.out.print("  fensterbreite : "); System.out.println(this.fensterbreite);
		}
	}
	/** Die Argumente sind eine Menge (der Vector) von Zeilenelementen und die y-Position
	  * der neuen Zeile.
	  */
	public TextZeile( Vector elemente, int y, int fensterbreite ) {
		super();
		zeilenelemente = new Vector();
		this.y = y;
		this.fensterbreite = fensterbreite;
		// Bei Mittigen bzw rechts ausgerichteten Zeilen istformat setzen
		if ( elemente.size() > 0 ) {
			ZwischenElement zwe = (ZwischenElement) elemente.elementAt(0);
			// prfen, ob mittig oder rechts ausgerichtet
			istformat = istFormat( zwe );
		}
		// Elemente in die Zeile einfgen.
		for ( int i = 0 ; i < elemente.size() ; i++ ) {     // fr alle Elemente des Vectors
			// ZwischenElement in eine Zeilenelement umwandeln
			ZeilenElement ze = convert ( (ZwischenElement) elemente.elementAt(i) );
			// Dem ListenStatus berprfen
			checkList( ze );
			breite += ze.gibBreite();			// Breite erhhen
			zeilenelemente.addElement( ze );	// Element an die Liste anfgen
		}
		if (MadScape.MadScape.TRACE) {
			System.out.println("new TextZeile(Vector, y, fensterbreite)");
			System.out.print("  y             : "); System.out.println(this.y);
			System.out.print("  fensterbreite : "); System.out.println(this.fensterbreite);
		}

	}
	/** Die TextZeile wird mit einem neuene Element und der y-Position initialisiert.
	  */
	public TextZeile( ZwischenElement element, int y, int fensterbreite ) {
		super();
		zeilenelemente = new Vector();
		this.y = y;
		this.fensterbreite = fensterbreite;
		// Bei Mittigen bzw rechts ausgerichteten Zeilen istformat setzen
		// prfen, ob mittig oder rechts ausgerichtet
		istformat = istFormat( element );
		// ZeilenElemente in die Zeile einfgen
		// ZwischenElement in eine Zeilenelement umwandeln
		ZeilenElement ze = convert ( element );
		// Dem ListenStatus berprfen
		checkList( ze );
		// Zeilenbreite neu setzen
		breite += ze.gibBreite();
		// Element einfgen
		zeilenelemente.addElement( ze );
		if (MadScape.MadScape.TRACE) {
			System.out.println("new TextZeile(ZwischenElement, y, fensterbreite)");
			System.out.print("  y             : "); System.out.println(this.y);
			System.out.print("  fensterbreite : "); System.out.println(this.fensterbreite);
		}
	}
	/** &Uuml;bergeben werden x- und y-Position der neuen Zeile und der zur
	  * Verf&uuml,gung stehende Platz.
	  */
	public TextZeile( int x, int y , int fensterbreite ) {
		super();
		zeilenelemente = new Vector();
		this.x = x;
		this.y = y;
		this.fensterbreite = fensterbreite;
		if (MadScape.MadScape.TRACE) {
			System.out.println("new TextZeile(x, y, fensterbreite)");
			System.out.print("  x             : "); System.out.println(this.x);
			System.out.print("  y             : "); System.out.println(this.y);
			System.out.print("  fensterbreite : "); System.out.println(this.fensterbreite);
		}
	}
	/** Die Argumente sind eine Menge (der Vector) von Zeilenelementen ,die
	  * x- und y-Position der neuen Zeile und der zur Verf&uuml;gung stehende Platz.
	  */
	public TextZeile( Vector elemente, int x, int y, int fensterbreite ) {
		super();
		zeilenelemente = new Vector();
		this.x = x;
		this.y = y;
		this.fensterbreite = fensterbreite;
		// Bei Mittigen bzw rechts ausgerichteten Zeilen istformat setzen
		if ( elemente.size() > 0 ) {
			ZwischenElement zwe = (ZwischenElement) elemente.elementAt(0);
			// prfen, ob mittig oder rechts ausgerichtet
			istformat = istFormat( zwe );
		}
		// Elemente in die Zeile einfgen.
		for ( int i = 0 ; i < elemente.size() ; i++ ) {     // fr alle Elemente des Vectors
			// ZwischenElement in eine Zeilenelement umwandeln
			ZeilenElement ze = convert ( (ZwischenElement) elemente.elementAt(i) );
			// Wird das erste Element in die Zeile eingefgt - 
			// Dem ListenStatus berprfen
			checkList( ze );
			breite += ze.gibBreite();                  // Breite erhhen
			zeilenelemente.addElement( ze );           // Element an die Liste anfgen
		}
		if (MadScape.MadScape.TRACE) {
			System.out.println("new TextZeile(Vector, x, y, fensterbreite)");
			System.out.print("  x             : "); System.out.println(this.x);
			System.out.print("  y             : "); System.out.println(this.y);
			System.out.print("  fensterbreite : "); System.out.println(this.fensterbreite);
		}

	}
	/** Die TextZeile wird mit einem neuene Element, x- und y-Position,
	  * und der zur Verf&uuml;gung stehenden Breite initialisiert.
	  */
	public TextZeile( ZwischenElement element, int x, int y, int fensterbreite ) {
		super();
		zeilenelemente = new Vector();
		this.x = x;
		this.y = y;
		this.fensterbreite = fensterbreite;
		// Bei Mittigen bzw rechts ausgerichteten Zeilen istformat setzen
		// prfen, ob mittig oder rechts ausgerichtet
		istformat = istFormat( element );
		// ZeielenElemente in die Zeile einfgen
		// ZwischenElement in eine Zeilenelement umwandeln
		ZeilenElement ze = convert ( element );
		// Dem ListenStatus berprfen
		checkList( ze );
		// Breite verbreitern
		breite += ze.gibBreite();
		// Element einfgen
		zeilenelemente.addElement( ze );
		if (MadScape.MadScape.TRACE) {
			System.out.println("new TextZeile(ZwischenElement, x, y, fensterbreite)");
			System.out.print("  x             : "); System.out.println(this.x);
			System.out.print("  y             : "); System.out.println(this.y);
			System.out.print("  fensterbreite : "); System.out.println(this.fensterbreite);
		}

	}



	//  Methoden

	/** Liefert die Breite des TextZeile,
	  */
	public int gibBreite() {
		return breite;
	}


	/** Liefert die H&ouml;he der TextZeile.
	  */
	public int gibHoehe() {
		return hoehe;
	}

	/** Tr&auml;gt ein Zwischenelement in die TextZeile ein, falls es reinpa&szlig;t.
	  * @param element - einzuf&uuml;gendes Zwischenelement.
	  * @return Gibt an, ob das Zwischenelement in den Zeilenblock pa&szlig;t,
	  * ohne die Breite des Ausgabefensters zu sprengen.
	  * @see MadScape.Zwischenrepraesentation.Zwischenelement
	  */
	public boolean fuegeAn( ZwischenElement element ) {
		// Bei Mittigen bzw rechts ausgerichteten Zeilen istformat setzen
		if ( zeilenelemente.size() == 0 ) {
			// prfen, ob mittig oder rechts ausgerichtet
			istformat = istFormat( element );
		}
		// ZeilenElement - Object erzeugen
		// ZwischenElement in eine Zeilenelement umwandeln
		ZeilenElement ze = convert ( element );
		// Dem ListenStatus berprfen
		checkList( ze );
		// Testen, ob es auf die Zeile passt, oder ob es das erste in der Zeile ist
		if ( ( (breite + ze.gibBreite()) <= fensterbreite ) | ( breite == einrueckung ) ) {
			breite += ze.gibBreite();
			zeilenelemente.addElement( ze );
			if (MadScape.MadScape.TRACE) {
				System.out.println("TextZeile.fuegeAn(ZE): Zeile noch nicht voll");
				System.out.print("  Breite        : "); System.out.println(breite);
				System.out.print("  Fensterbreite : "); System.out.println(fensterbreite);
				System.out.print("  Einrueckung   : "); System.out.println(einrueckung);
			}
			return true;
		}
		else {
			if (MadScape.MadScape.TRACE) {
				System.out.println("TextZeile.fuegeAn(ZE): Zeile ist voll");
				System.out.print("  Breite        : "); System.out.println(breite);
				System.out.print("  Fensterbreite : "); System.out.println(fensterbreite);
				System.out.print("  Einrueckung   : "); System.out.println(einrueckung);
			}
			return false;
		}
	} // end boolean fuegeAn


	/** Tr&auml;gt eine Liste von Zwischenelementen ein, falls sie reinpa&szlig;t.
	  * @param liste - Liste der einzuf&uuml;genden Zwischenelemente.
	  * @returns Gibt an, ob die Liste von Zwischenelementen in die TextZeile pa&szlig;t,
	  * ohne die Breite des Ausgabefensters zu sprengen.
	  * @see MadScape.Zwischenrepraesentation.Zwischenelement
	  */
	public boolean fuegeAn( Vector elemente ) {
		// Bei Mittigen bzw rechts ausgerichteten Zeilen istformat setzen
		if ( ( zeilenelemente.size() == 0 ) & ( elemente.size() > 0 ) ) {
			ZwischenElement zwe = (ZwischenElement) elemente.elementAt(0);
			// prfen, ob mittig oder rechts ausgerichtet
			istformat = istFormat( zwe );
		}
		ZeilenElement [] zetempliste = new ZeilenElement [elemente.size()];   // Temporre Liste zum checken der Lnge
		int tempbreite = 0;                                                     // Gesamtbreite der einzuf. Elemente
		// Umformen und zwischenspeichern der bergebenen Elemente in temporrer Liste
		// gleichzeitig breite dieser temporren Liste berechen:
		for ( int i = 0 ; i < elemente.size() ; i++ ) {
			// ZwischenElement in eine Zeilenelement umwandeln
			ZeilenElement ze = convert ( (ZwischenElement) elemente.elementAt(i) );
			// Dem ListenStatus berprfen
			checkList( ze );
			tempbreite += ze.gibBreite();
			zetempliste[i] = ze;
		}
		// Falls alle Elemente noch auf die Zeile passen, oder die Zeile anfngt
		if ( ( breite + tempbreite <= fensterbreite ) | ( breite == einrueckung ) ) {
			// alle Elemente an die Zeilen anfgen
			for (int i = 0 ; i < zetempliste.length ; i++ ) {
				zeilenelemente.addElement( zetempliste[i] );
			}
			breite += tempbreite;
			// erfolgreich angefgt
			if (MadScape.MadScape.TRACE) {
				System.out.println("TextZeile.fuegeAn(Vector): Element passt");
				System.out.print("  Breite        : "); System.out.println(breite);
				System.out.print("  Fensterbreite : "); System.out.println(fensterbreite);
				System.out.print("  Einrueckung   : "); System.out.println(einrueckung);
			}
			return true;
		// Falls nicht alle Elemente auf die Zeile passen
		} else {
			// Fehler signalisieren
			if (MadScape.MadScape.TRACE) {
				System.out.println("TextZeile.fuegeAn(Vector): Zeile voll");
				System.out.print("  Breite        : "); System.out.println(breite);
				System.out.print("  Fensterbreite : "); System.out.println(fensterbreite);
				System.out.print("  Einrueckung   : "); System.out.println(einrueckung);
			}
			return false;
		}
	} // end boolean fuegeAn

	
	public void schliesse() {
		if  ( zeilenelemente.size() != 0 ) {
			for ( int i = 0 ; i < zeilenelemente.size() ; i++ ) {
				ZeilenElement ze = (ZeilenElement) zeilenelemente.elementAt(i);
				if ( ze.gibUeberhoehe() > ueberhoehe ) {
					ueberhoehe = ze.gibUeberhoehe();
				}
				if ( ze.gibUnterhoehe() > unterhoehe ) {
					unterhoehe = ze.gibUnterhoehe();
				}
				// Bei mittigen bzw rechts ausgerichteten Zeilen den x-Wert neu berechnen
				if ( istformat == CENTER ) {
					ze.setzeX( ze.gibX() + ( ( fensterbreite - breite ) / 2 ) );
				} else if ( istformat == RIGHT ) {
					ze.setzeX( ze.gibX() + ( fensterbreite - breite ) );
				}
			}
			int yneu = y + ueberhoehe;       // neue Grundlinienposition der ZeilenElemente
			for ( int i = 0 ; i < zeilenelemente.size() ; i++ ) {
				ZeilenElement ze = (ZeilenElement) zeilenelemente.elementAt(i);
				ze.setzeY(yneu);               // neue Grundlinienposition setzen
			}
			hoehe = ueberhoehe + unterhoehe; // Hhe der Zeile neu berechnen
		}
	} // end void schliesse

	/** Initiiert das Zeichnen der TextZeile.
	  */
	public void zeichneDich(Graphics graphics, LinkMenge links, AnkerMenge anker) {
		if (MadScape.MadScape.TRACE) {
			System.out.println("TextZeile.zeichneDich(Graphics, LinkMenge, AnkerMenge)");
			System.out.print("  ");
		}
		// Hat man es mit einer Liste zu tun, muss u.U. ein Symbol gezeichnet werden
		if (zeilenelemente.size() > 0) {
			ZeilenElement ze = (ZeilenElement) zeilenelemente.elementAt(0);
			Attribute zeattrib =  ze.gibAttribute();
			if (zeattrib.istlisteneintrag() ) {
				if (zeattrib.istersterlisteneintrag()) {
					int mitte = y + (hoehe / 2);
					graphics.setColor(Color.black);
					switch (symbol) {
						default: // Rechteck (Square)
							graphics.drawRect(x+einrueckung - 11, mitte-3, 6, 6);
							break;
						case DISC: // Ausgefuellter Kreis (Disk)
							graphics.fillOval(x+einrueckung - 11, mitte-3, 6, 6);
							break;
						case CIRCLE: // Kreis (Circle)
							graphics.drawOval(x+einrueckung - 11, mitte-3, 6, 6);
							break;
					}
				}
			}
		}

		for ( int i = 0 ; i < zeilenelemente.size() ; i++ ) {
			ZeilenElement ze = (ZeilenElement) zeilenelemente.elementAt(i);
			ze.zeichneDich( graphics, links, anker );
			if (MadScape.MadScape.TRACE) {
				System.out.print(i);System.out.print(" ");
			}
		}
		if (MadScape.MadScape.TRACE) System.out.println(" ZeilenElemente gezeichnet");
	} // end void zeichneDich
	
	// prfen, ob die Zeile mittig, oder rechts ausgerichtet ist
	private final int istFormat( ZwischenElement zwe ) {
		switch ( zwe.gibausrichtung() ) {
			default:
				return LEFT;
			case ZwischenElement.MITTEL:
				return CENTER;
			case ZwischenElement.RECHTS:
				return RIGHT;
		}
	}

	// Konvertiert ein ZwischenElement in das passende ZeilenElement
	private final ZeilenElement convert ( ZwischenElement zwe ) {
		ZeilenElement ze = new Leerzeichen();
		switch ( zwe.gibTyp() ) {
			case ZwischenElement.WORT:
				ze = new Wort( (MadScape.Zwischenrepraesentation.Wort) zwe , x + breite );
				break;
			case ZwischenElement.BILD:
				ze = new Bild( (MadScape.Zwischenrepraesentation.Bild) zwe , x + breite );
				break;
			case ZwischenElement.LEERZEICHEN:
				ze = new Leerzeichen( (MadScape.Zwischenrepraesentation.Leerzeichen) zwe , x + breite );
				break;
			}
		return ze;
	}
	
	// Prft, ob das Zeilenelement ein Listeneintrag ist und ndert ggf die x-Position
	// und das Listensymbol
	private final void checkList( ZeilenElement ze ) {
		// Handelt es sich um das erste Element in der Zeile
		if ( zeilenelemente.size() == 0 ) {
			// Prfen, ob man es mit einer Liste zu tun hat.
			Attribute zeattrib = ze.gibAttribute();
			if ( zeattrib.istlisteneintrag() ) {
				einrueckung = zeattrib.giblistenzaehler() * listspace;
				switch ( zeattrib.giblistentyp() ) {
					default: symbol = SQUARE; break;
					case 2:  symbol = CIRCLE; break;
					case 3:  symbol = DISC; break;
				}
				if ( MadScape.MadScape.TRACE ) {
					System.out.println("TextZeile bekam eine Liste");
					System.out.println(symbol);
				}
			}
			// Zeilenbreite neu setzen
			breite = einrueckung;
			// Das Element einrcken
			ze.setzeX( breite + x);
		}
	}


} // end class TextZeile
