package MadScape.FormatierteSeite;

import java.util.Vector;
import MadScape.FormatierteSeite.LinkBereich;

/**
 * Menge aller Links in einer Seite
 * @author Ronny Manthey, Stefan Strigler
 */
public class LinkMenge extends Vector {

  /**
   * erzeugt einen Vektor, an den alle Links angehngt werden knnen
   */
  public LinkMenge() {
    super();
  }
 
  /**
   * hngt einen Link an die LinkMenge an
   * @param link Ein LinkBereich
   */
  public void fuegeAn(LinkBereich link) {
    if (this.size()!=0) {
      LinkBereich lastLink = (LinkBereich) this.lastElement();
      if ((link.y==lastLink.y) && 
	  (link.x==(lastLink.x + lastLink.width)) &&
	  (link.height==lastLink.height) && 
	  (link.referenz.equalsIgnoreCase (lastLink.referenz) ))  {
	
	LinkBereich neuLink = new LinkBereich(link.referenz, lastLink.x, lastLink.y, (link.width+lastLink.width), lastLink.height);
	this.setElementAt(neuLink, this.size()-1);
      } else this.addElement(link);
    } else  this.addElement(link); // noch keiner zum Vergleichen dagewesen
    
  }
  
  /**
   * kuckt, ob sich an angegebener Stelle ein Link befindet
   * @param x Koordinate
   * @param y Koordinate
   */
  public boolean istLink(int x, int y) {
    for (int i=0; i<this.size(); i++)
      if (((LinkBereich)this.elementAt(i)).liegtDrin(x,y) ) return true;
    return false;
  }

  /**
   * gibt die URL eines Links als String zurck
   * @param X Koordinate die geklickt wurde
   * @param Y Koordinate die geklickt wurde
   * @return url
   */
  public String holeLink(int x, int y) {
    for (int i=0; i < this.size(); i++){
      if (((LinkBereich)this.elementAt(i)).liegtDrin(x,y)) {
	String ret = new String (((LinkBereich)this.elementAt(i)).referenz );
	return ret;
      }
    }
    return null;
  }


  /**
   * Testmethode, mit Hilfe derer man rausfinden knne soll, ob benachbarte LinkBereiche miteinander verschmolzen werden
   */
  public void mergeTest(){
    int x1, x2, y;
    System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    System.out.println("\tHier kommt die Testausgabe der LinkMenge\n");
    for (int i=0; i < this.size(); i++) {
      x1 = ((LinkBereich)this.elementAt(i)).x;
      x2 = x1 + (((LinkBereich)this.elementAt(i)).width);
      y  = ((LinkBereich)this.elementAt(i)).y;
      System.out.println( i + ". Link geht von " + x1 + " bis " + x2 + " bei y=" + y);
    }
  }
}


