package MadScape.FormatierteSeite;
import java.awt.Rectangle;

/**
 * LinkBereich sind die hypertext&shy;sensiblen Bereiche unserer WebPage,
 * von denen aus weitergeklickt werden kann. "Unter" ihnen befindet sich
 * eine Referenz (auch URL genannt), auf die dann hingesprungen wird. 
 * @author Ronny Manthey, Stefan Strigler
 */
public class LinkBereich extends Rectangle {
  String referenz;

  /**
   * Erzeugt einen neuen anklickbaren Bereich
   * @param referenz  der Hyperlink, der angesprungen werden kann
   * @param x,y  die Position des Bereichs
   * @param width,height die Ausdehnung desselben
   */
  public LinkBereich(String ref, int x, int y, int width, int height){
    super(x, y, width, height);
    this.referenz = new String (ref); // sicherheitshalber klonen  }
  }

  /**
   * Kuckt, ob die angegebenen Koordinaten im Rechteck liegen
   * @param x die x&shy;Koordinate
   * @param y die y&shy;Koordinate
   * @return liefert <TT>true</TT>, wenn der Punkt "drin" liegt
   */
  public boolean liegtDrin(int x, int y) {
    return this.contains(x, y);
  }

}


