package MadScape.FormatierteSeite;
import MadScape.Zwischenrepraesentation.*;
import java.awt.*;

/** Klasse f&uuml;r die Darstellung eines Leerzeichens in der formatierten
 *   Seite. 
 *	 @author Alexander L&uuml;ning
 *   @author Alexander Knabner
 *	 @author Thomas Sundermann
 */
public class Leerzeichen extends ZeilenElement {

  /** attribute enth&auml;lt die Attribute des Leerzeichens	*/
	public Attribute attribute;
  
  private Font schrift;
  private FontMetrics schriftwerte;
	private Color farbe;  

	/**ein leerer Konstruktor...*/
	public Leerzeichen(){
	}

  /**Konstruktor zum Erzeugen eines Leerzeichen-Objektes
  * @param zelement Da&szlig; zu verarbeitende Zwischenelement
	* @param x Die X-Position in der Zeile
  */
  public Leerzeichen(MadScape.Zwischenrepraesentation.Leerzeichen zelement, int x){
    super();
    this.attribute=zelement.gibattribute();
		this.x = x;
    schrift = attribute.gibschrift();
		Toolkit tk = Toolkit.getDefaultToolkit();
    schriftwerte = tk.getFontMetrics( schrift);
    ueberhoehe = schriftwerte.getMaxAscent();
    unterhoehe = schriftwerte.getMaxDescent();
    breite = schriftwerte.charWidth(' ');
    hoehe = ueberhoehe+unterhoehe;
    farbe = attribute.gibfarbe();
    if (MadScape.MadScape.TRACE) { 
	    System.out.print("Leerzeichen.Leerzeichen(): Ich bin ein Leerzeichen");
  	  System.out.print("  X-Pos: ");System.out.print(x);
    	System.out.print("  Y-Pos: ");System.out.print(y);
	    System.out.print("  Breite: ");System.out.print(breite);
  	  System.out.print("  Hhe: ");System.out.println(hoehe);
		}
	}

  /** Methode, die die Attribute des Leerzeichens liefert*/
  public Attribute gibAttribute(){
		return attribute;
	}

  /** Methode, die das Leerzeichen auf dem Bildschirm darstellt
  *  @param g das Graphics-Objekt in das gezeichnet wird
  */
  public void zeichneDich(Graphics g, LinkMenge link, AnkerMenge anker) {
    g.setColor(farbe);
    g.setFont(schrift);
    g.drawString(" ", x, y);
    if (attribute.istunterstrichen()) g.drawLine(x,(y+1),(x+breite),(y+1));
    if (attribute.istverweis()) {
      if (MadScape.MadScape.TRACE) { 
				System.out.println("Leerzeichen.zeichneDich: Leerzeichen in Linkmenge");
      }
      link.fuegeAn(new LinkBereich(attribute.gibverweistext(), x, (y-ueberhoehe), breite, hoehe));
    }
    if (attribute.istanker()) {
      if (MadScape.MadScape.TRACE) { 
				System.out.println("Leerzeichen.zeichneDich: Leerzeichen in Ankermenge");
      }
      anker.fuegeAn(new Anker(attribute.gibverweistext(), (y-ueberhoehe)));
    }
    if (MadScape.MadScape.TRACE) { 
			System.out.println("Leerzeichen.zeichneDich: Leerzeichen gezeichnet");
    }

  }
}