package MadScape.FormatierteSeite;

import java.awt.*;
import java.awt.image.*;
import java.lang.*;
import java.util.*;
import MadScape.Zwischenrepraesentation.*;

/** Diese Klasse stellt eine fertig formatierte Seite dar, die ausgegeben werden kann.
  */
public class FormatierteSeite{
	private ZRSeite zrSeite;
	private int fensterhoehe, fensterbreite, anzeigebreite;
	private String titel;
	private Image hintergrundbild;
	private boolean wasserzeichen;
	private Color hintergrundfarbe;
	private Vector zeilen=new Vector();		// Liste der Zeilenblcke
	private boolean umlaufbildAn = false;

	private AnkerMenge anker;	// Liste der  Anker
	private LinkMenge links;	// Liste der LinkBereiche

	private int aktuelleHoehe=0;
	private int maximaleBreite;

	private int anzahlZE=0;

/** Konstruktor erzeugt die Formatierte Seite, samt fertigem Bild und der Link- sowie Ankerliste.
 *	@param quelle Zwischenrepraesentation, die in eine formatierte Seite umgewandelt werden soll
 *	@param breite Breite des Ausgabefensters, die zur Verfgung steht.
 */
	public FormatierteSeite(ZRSeite quelle, int hoehe, int breite, int scrollbarbreite){
if(MadScape.MadScape.TRACE) System.out.println("FormatierteSeite.FormatierteSeite() : (Breite "+breite+")..."+quelle);
		this.zrSeite = quelle;
		this.fensterhoehe=hoehe;//-3;
		this.anzeigebreite=breite-scrollbarbreite;//-7;
		this.fensterbreite=breite;//-3;
		this.maximaleBreite=anzeigebreite;
		hintergrundbild=quelle.gibhintergrund();
		hintergrundfarbe=quelle.gibhintergrundfarbe();
		wasserzeichen=quelle.gibhintergrundeigenschaften();

		int anz=quelle.gibanzahlelemente();
		int i=0;
		boolean nobrmodus=false, ende=false;
//		hoehe=0;
		breite=0;
		ZwischenElement ein;
		Vector nobrliste=new Vector();
		ZeilenBlock ziel=null; // = new Zeile( ein, aktuelleHoehe, anzeigebreite);
if(MadScape.MadScape.TRACE) System.out.println("FormatierteSeite.FormatierteSeite() : Algorithmusbeginn mit "+anz+" Elementen");
		while(i<anz){
			ein=quelle.gibzwischenelementbei(i);
			if(nobrmodus){
				if(i++<anz){
					switch(ein.gibTyp()){
						case ZwischenElement.WORT:
							nobrliste.addElement(ein);
							ein=quelle.gibzwischenelementbei(i);
							if(ein.gibTyp()!=ZwischenElement.LEERZEICHEN){
								nobrmodus=false;
							}else if(!((MadScape.Zwischenrepraesentation.Leerzeichen)ein).gibkeinumbruch()){
								nobrmodus=false;
								nobrliste.addElement(ein);
								i++;
							}
						break;
						case ZwischenElement.BILD:
							if((ein.gibausrichtung()==ZwischenElement.RECHTS)||(ein.gibausrichtung()==ZwischenElement.LINKS)){
								nobrmodus=false;
								--i;
							}else{
								nobrliste.addElement(ein);
								ein=quelle.gibzwischenelementbei(++i);
								if(ein.gibTyp()==ZwischenElement.LEERZEICHEN)
									nobrmodus=false;
								else if(!((MadScape.Zwischenrepraesentation.Leerzeichen)ein).gibkeinumbruch())
									ende=true;
							}
						break;
						case ZwischenElement.LEERZEICHEN:
							if(!((MadScape.Zwischenrepraesentation.Leerzeichen)ein).gibkeinumbruch())
								nobrmodus=false;
							else
								nobrliste.addElement(ein);
						break;
						default:
							nobrmodus=false;
					}
				}else{
					nobrliste.addElement(ein);
					nobrmodus=false;
				}
				if(!nobrmodus){		// falls sich der Modus gerade geaendert hat
					if(!ziel.fuegeAn(nobrliste)){
						schliesseZeilenBlock(ziel);
						ziel = new TextZeile(nobrliste, aktuelleHoehe, anzeigebreite);
					}
				}
					
			}else{
				switch(ein.gibTyp()){
					case ZwischenElement.WORT:
if(MadScape.MadScape.TRACE) System.out.println("FormatierteSeite.FormatierteSeite() :   Wort erhalten");
						if(ziel==null){
							ziel = new TextZeile( aktuelleHoehe, anzeigebreite);
						}
						ZwischenElement dummy=quelle.gibzwischenelementbei(++i);
						if(dummy.gibTyp()==ZwischenElement.LEERZEICHEN){
							if(((MadScape.Zwischenrepraesentation.Leerzeichen)dummy).gibkeinumbruch()){	// nchstes Elem. ist Leerzeichen
								nobrliste = new Vector();			// Leerzeichen ist nicht umbrechbar
								nobrliste.addElement(ein);
								nobrliste.addElement(dummy);
								nobrmodus=true;
								i++;
							}else{
								if(!ziel.fuegeAn(ein)){				// Leerzeichen ist umbrechbar
									schliesseZeilenBlock(ziel);		// pat nicht rein
									ziel=new TextZeile(ein, aktuelleHoehe, anzeigebreite);
								}
							}
						}else{
							if(!ziel.fuegeAn(ein)){					// nchstes Elem. ist kein Leerzeichen
								schliesseZeilenBlock(ziel);			// pat nicht rein
								ziel= new TextZeile( ein, aktuelleHoehe, anzeigebreite);
							}
						}
					break;
					case ZwischenElement.BILD:
						if((ein.gibausrichtung()==ZwischenElement.RECHTS)||(ein.gibausrichtung()==ZwischenElement.LINKS)){
							if( ziel!=null)
								schliesseZeilenBlock(ziel);				// Element ist UmlaufBild
							ziel = new UmlaufBild( (MadScape.Zwischenrepraesentation.Bild)ein, aktuelleHoehe, anzeigebreite);
							umlaufbildAn = true;
						}else{
							if(ziel==null)						// Element ist normales Bild
								ziel = new TextZeile(ein, aktuelleHoehe, anzeigebreite);// keine offene Zeile
							else{
								if(!ziel.fuegeAn(ein)){				// offene Zeile
									schliesseZeilenBlock(ziel);		// passt nicht rein
									ziel = new TextZeile(ein, aktuelleHoehe, anzeigebreite);
								}
							}
						}
						i++;
					break;
					case ZwischenElement.LEERZEICHEN:
if(MadScape.MadScape.TRACE) System.out.println("FormatierteSeite.FormatierteSeite() :   Leerzeichen erhalten");
						if(ziel==null){
							ziel = new TextZeile( ein, aktuelleHoehe, anzeigebreite);// keine offene Zeile
						}else if(!ziel.fuegeAn(ein)){					// offene Zeile
							schliesseZeilenBlock(ziel);				// pat nicht rein
							ziel = new TextZeile(ein, aktuelleHoehe, anzeigebreite);
						}
						i++;
					break;
					case ZwischenElement.HLINIE:
						if(ziel!=null){
							if(!umlaufbildAn){
								schliesseZeilenBlock(ziel);
								ziel = new Linie( aktuelleHoehe,  anzeigebreite);
								schliesseZeilenBlock(ziel);
							}else if(!ziel.fuegeAn(ein)){				// offene Zeile
								schliesseZeilenBlock(ziel);				// pat nicht rein, also Umlaufbild schlieen
								ziel = new Linie( aktuelleHoehe, anzeigebreite);
								schliesseZeilenBlock(ziel);
							}
						}else{
							ziel = new Linie( aktuelleHoehe,  anzeigebreite);
							schliesseZeilenBlock(ziel);
						}
						i++;
					break;
					case ZwischenElement.UMBRUCH:
						if(ziel!=null){
							schliesseZeilenBlock(ziel);
							ziel=null;
						}else{
							aktuelleHoehe+=12;
						}
						i++;
					break;
					default:
if(MadScape.MadScape.TRACE) System.out.println("  unbekanntes ZwischenElement : " + ein.gibTyp());
						i++;
					break;
				}
			}
		}
	if(ziel!=null)
		schliesseZeilenBlock(ziel);
	}
	
	private void schliesseZeilenBlock( ZeilenBlock z){
if(MadScape.MadScape.TRACE) System.out.println("FormatierteSeite.schliesseZeilenBlock() : Zeile beendet");
		z.schliesse();
		if( z.gibHoehe()!=0){
			aktuelleHoehe+=z.gibHoehe();
//			System.out.println("Zeile mit" + z.gibHoehe() + "Hoehe.");
		}else{
			aktuelleHoehe+=7;
			System.out.println("leere Zeile!");
		}
		if(z.gibBreite()>maximaleBreite)
			maximaleBreite=z.gibBreite();
		zeilen.addElement(z);
		umlaufbildAn = false;
	}
	
/** Liefert die Liste aller Linkbereiche im aktuellen Dokument. */
	public LinkMenge gibLinkliste(){ return links; }

/** Liefert die Liste aller Ankerbereiche im aktuellen Dokument. */
	public AnkerMenge gibAnkerliste(){return anker;}

/** Liefert das fertige Bild, das gemalt werden kann.
  * @param quelle component-Objekt, auf das das Bild gezeichnet werden soll, mu sichtbar sein.
  */
	public Image erzeugeBild(Component quelle){

		if((aktuelleHoehe<=fensterhoehe)&&(maximaleBreite<=anzeigebreite))
			maximaleBreite = fensterbreite;
		if(aktuelleHoehe<fensterhoehe)
			aktuelleHoehe = fensterhoehe;

if(MadScape.MadScape.TRACE) System.out.println("FormatierteSeite.erzeugeBild() :("+maximaleBreite+":"+aktuelleHoehe+")");
		Image offI = quelle.createImage( maximaleBreite, aktuelleHoehe);
if(MadScape.MadScape.TRACE) System.out.println("FormatierteSeite.erzeugeBild() :  Image erzeugt...");
		Graphics offG = offI.getGraphics();
if(MadScape.MadScape.TRACE) System.out.print("FormatierteSeite.erzeugeBild() :  Graphics erzeugt");
		ZeilenBlock zb;

		if( hintergrundbild!=null){
			int bbreite=hintergrundbild.getWidth(null);
			int bhoehe=hintergrundbild.getHeight(null);
			int x_wieoft = (maximaleBreite-1)/bbreite+1;
			int y_wieoft = (aktuelleHoehe-1)/bhoehe+1;

if(MadScape.MadScape.TRACE) System.out.print("FormatierteSeite.erzeugeBild() :  zeichne Hintergrundbild...("+x_wieoft+"x"+y_wieoft+")");

			for(int i=0; i<x_wieoft; i++){		// Hintergrundbild zeichnen
				for(int j=0; j<y_wieoft; j++){
					offG.drawImage( hintergrundbild, i*bbreite, j*bhoehe, null);
				}
			}
		}else{
			offG.setColor( hintergrundfarbe);
			offG.fillRect(0,0, maximaleBreite, aktuelleHoehe);
		}

		links = new LinkMenge();
		anker = new AnkerMenge();
		for(int i=0; i<zeilen.size(); i++){
			zb = (ZeilenBlock)zeilen.elementAt(i);
			zb.zeichneDich( offG, links, anker);
//if(MadScape.TRACE) System.out.print(".");
		}
if(MadScape.MadScape.TRACE) links.mergeTest();
if(MadScape.MadScape.TRACE) System.out.println("FormatierteSeite.erzeugeBild() :  Bild gezeichnet");

		return offI;
	}
}