package MadScape.FormatierteSeite;
import MadScape.Zwischenrepraesentation.*;
import java.awt.*;

/** Klasse f&uuml;r die Darstellung von Bildern in der formatierten
 *   Seite. Wird auch zum Zeichnen von Umlaufbildern verwendet.
 *   @author Alexander L&uuml;ning
 *   @author Alexander Knabner
 *	 @author Thomas Sundermann
 */
public class Bild extends ZeilenElement {

  /** attribute enth&auml;lt die Attribute des Bildes	*/
	public Attribute attribute;

  /** bild enth&auml;lt das darzustellende Bild. */
  public Image bild;

  private BildObserver dummy = new BildObserver();
  
  /**Konstruktor zum Erzeugen eines Bild-Objektes
  * @param zelement Da&szlig; zu verarbeitende Zwischenelement
	* @param x Die X-Position in der Zeile
  */
  public Bild(MadScape.Zwischenrepraesentation.Bild zelement, int x){
    super();
    this.bild=zelement.gibbild();
		this.x = x;
    int ausrichtung = zelement.gibausrichtung();
    attribute=zelement.gibattribute();
    if (zelement.gibistprozent()) {
		  breite = zelement.gibbreite() * bild.getWidth(dummy)/100;
  	  hoehe = zelement.gibhoehe() * bild.getHeight(dummy)/100;
    }
    else {
	  breite = zelement.gibbreite();
  	  hoehe = zelement.gibhoehe();
    }			
    if (ausrichtung==zelement.MITTEL) {
      ueberhoehe = hoehe / 2;
      unterhoehe = hoehe - ueberhoehe;
    }
    else if (ausrichtung==zelement.OBEN) {
      ueberhoehe = 0;
      unterhoehe = hoehe;
    }
    else {
      ueberhoehe = hoehe;
      unterhoehe = 0;
    }
    if (MadScape.MadScape.TRACE) {
      System.out.print("Bild.Bild(): Ich bin ein Bild");
      System.out.print("  X-Pos: ");System.out.print(x);
      System.out.print("  Y-Pos: ");System.out.print(y);
      System.out.print("  Breite: ");System.out.print(breite);
      System.out.print("  Hhe: ");System.out.println(hoehe);
    }
  }

  /** Methode, die die Attribute des Bildes zur&uuml;ckgibt*/
  public Attribute gibAttribute(){
		return attribute;
	}

  /** Methode die das Bild auf dem Bildschirm darstellt
  *  @param g ein Graphics-Objekt in das gezeichnet wird
  */
  public void zeichneDich(Graphics g, LinkMenge link, AnkerMenge anker){
  	g.drawImage(bild, x, (y-ueberhoehe), breite, hoehe, dummy);
	  if (MadScape.MadScape.TRACE) { 
  	  System.out.println("Bild.zeichneDich: Bild gezeichnet " + x + ", " + (y-ueberhoehe));
	  }
  	if (attribute.istverweis()) {
    	if (MadScape.MadScape.TRACE) { 
      	System.out.println("Bild.zeichneDich: Bild in Linkmenge");
	    }
  	  link.fuegeAn(new LinkBereich(attribute.gibverweistext(), x, (y-ueberhoehe), breite, hoehe));
	  }
  	if (attribute.istanker()) {
    	if (MadScape.MadScape.TRACE) { 
      	System.out.println("Bild.zeichneDich: Bild in Ankermenge");
	    }
  	  anker.fuegeAn(new Anker(attribute.gibverweistext(), (y-ueberhoehe)));
	  } 
  }
   
}
 
  
