package MadScape.FormatierteSeite;

import java.util.*;
import MadScape.FormatierteSeite.Anker;

/**
 * Menge der lokalen Anker einer Seite
 * @author Ronny Manthey, Stefan Strigler
 */
public class AnkerMenge extends Vector {

  /**
   * erzeugt einen Vektor, der alle Anker verwaltet
   */
  public AnkerMenge() {
    super();
  }

  /**
   * fuegt ein Element vom Typ Anker in die Menge ein
   * @param anker Der Anker, der angefgt werden soll
   * @see Anker
   */
  public void fuegeAn(Anker anker) {
     this.addElement(anker);
  }

  /**
   * liefert die Y-Koordinate eines gegebenen lokalen Ankers zurck
   */ 
  public int woIst(String name) throws KeinAnkerException {
    Anker anker;
    if (this.isEmpty()) throw new KeinAnkerException("Ankerliste leer");
    else for (int i=0; i < this.size(); i++) {
      anker = (Anker) this.elementAt(i);
      if (name.equalsIgnoreCase(anker.name)) return anker.y;
    }
    throw new KeinAnkerException("Kein Anker mit diesem Namen vorhanden");
  }
}




