
package MadScape;

import java.awt.*;

/**
 * Ein CacheBild ist ein Image-Objekt mit dazugehriger URL
 * (als String), das vom Loader zurckgeliefert werden kann
 * wenn es schon einmal geladen wurde.
 */
public class CacheBild {

	Image bild;
	String ort;

//------------------------------------------------------------------------
// KONSTRUKTOR
//------------------------------------------------------------------------
	/**
	 * Ein CacheBild erzeugen. (String wird sicherheitshalber geklont,
	 * Bild natrlich nicht)
	 */
	public CacheBild (Image b, String url) {
		bild = b;
		ort = new String (url);
	}
//------------------------------------------------------------------------
// METHODEN
//------------------------------------------------------------------------
	/**
	 * Stimmt der bergebenen String mit der URL des Bildes berein?
	 * @param url der zu vergleichende String
	 * @return bool
	 */
	public boolean gleicheURL (String url) {
		return ort.equals(url);
	}
//------------------------------------------------------------------------
	/**
	 * Liefert das Bild.
	 * @return das Image-Objekt
	 */
	public Image holeBild () {
		return bild;
	}
}